/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.http.hc;

import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.NotThreadSafe;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import me.chanjar.weixin.common.util.http.hc.HttpComponentsClientBuilder;
import me.chanjar.weixin.common.util.http.hc.NoopRetryStrategy;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import org.apache.hc.client5.http.ssl.TrustAllStrategy;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class DefaultHttpComponentsClientBuilder
implements HttpComponentsClientBuilder {
    private static final Logger log = LoggerFactory.getLogger(DefaultHttpComponentsClientBuilder.class);
    private final AtomicBoolean prepared = new AtomicBoolean(false);
    private int connectionRequestTimeout = 3000;
    private int connectionTimeout = 5000;
    private int soTimeout = 5000;
    private int idleConnTimeout = 60000;
    private int checkWaitTime = 60000;
    private int maxConnPerHost = 10;
    private int maxTotalConn = 50;
    private String userAgent;
    private List<HttpRequestInterceptor> requestInterceptors = new ArrayList<HttpRequestInterceptor>();
    private List<HttpResponseInterceptor> responseInterceptors = new ArrayList<HttpResponseInterceptor>();
    private HttpRequestRetryStrategy httpRequestRetryStrategy;
    private ConnectionKeepAliveStrategy connectionKeepAliveStrategy;
    private String httpProxyHost;
    private int httpProxyPort;
    private String httpProxyUsername;
    private char[] httpProxyPassword;
    private CloseableHttpClient closeableHttpClient;

    private DefaultHttpComponentsClientBuilder() {
    }

    public static DefaultHttpComponentsClientBuilder get() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public HttpComponentsClientBuilder httpProxyHost(String httpProxyHost) {
        this.httpProxyHost = httpProxyHost;
        return this;
    }

    @Override
    public HttpComponentsClientBuilder httpProxyPort(int httpProxyPort) {
        this.httpProxyPort = httpProxyPort;
        return this;
    }

    @Override
    public HttpComponentsClientBuilder httpProxyUsername(String httpProxyUsername) {
        this.httpProxyUsername = httpProxyUsername;
        return this;
    }

    @Override
    public HttpComponentsClientBuilder httpProxyPassword(char[] httpProxyPassword) {
        this.httpProxyPassword = httpProxyPassword;
        return this;
    }

    @Override
    public HttpComponentsClientBuilder httpRequestRetryStrategy(HttpRequestRetryStrategy httpRequestRetryStrategy) {
        this.httpRequestRetryStrategy = httpRequestRetryStrategy;
        return this;
    }

    @Override
    public HttpComponentsClientBuilder keepAliveStrategy(ConnectionKeepAliveStrategy keepAliveStrategy) {
        this.connectionKeepAliveStrategy = keepAliveStrategy;
        return this;
    }

    private synchronized void prepare() {
        SSLContext sslcontext;
        if (this.prepared.get()) {
            return;
        }
        try {
            sslcontext = SSLContexts.custom().loadTrustMaterial((TrustStrategy)TrustAllStrategy.INSTANCE).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            log.error("\u6784\u5efa SSLContext \u65f6\u53d1\u751f\u5f02\u5e38\uff01", (Throwable)e);
            throw new RuntimeException(e);
        }
        PoolingHttpClientConnectionManager connManager = PoolingHttpClientConnectionManagerBuilder.create().setTlsSocketStrategy((TlsSocketStrategy)new DefaultClientTlsStrategy(sslcontext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).setMaxConnTotal(this.maxTotalConn).setMaxConnPerRoute(this.maxConnPerHost).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(this.soTimeout, TimeUnit.MILLISECONDS).build()).setDefaultConnectionConfig(ConnectionConfig.custom().setConnectTimeout((long)this.connectionTimeout, TimeUnit.MILLISECONDS).build()).build();
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).setConnectionManagerShared(true).setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout((long)this.connectionRequestTimeout, TimeUnit.MILLISECONDS).build());
        httpClientBuilder.setRetryStrategy((HttpRequestRetryStrategy)ObjectUtils.defaultIfNull((Object)this.httpRequestRetryStrategy, (Object)NoopRetryStrategy.INSTANCE));
        if (this.connectionKeepAliveStrategy != null) {
            httpClientBuilder.setKeepAliveStrategy(this.connectionKeepAliveStrategy);
        }
        if (StringUtils.isNotBlank((CharSequence)this.httpProxyHost) && StringUtils.isNotBlank((CharSequence)this.httpProxyUsername)) {
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            provider.setCredentials(new AuthScope(this.httpProxyHost, this.httpProxyPort), (Credentials)new UsernamePasswordCredentials(this.httpProxyUsername, this.httpProxyPassword));
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)provider);
            httpClientBuilder.setProxy(new HttpHost(this.httpProxyHost, this.httpProxyPort));
        }
        if (StringUtils.isNotBlank((CharSequence)this.userAgent)) {
            httpClientBuilder.setUserAgent(this.userAgent);
        }
        this.requestInterceptors.forEach(arg_0 -> ((HttpClientBuilder)httpClientBuilder).addRequestInterceptorFirst(arg_0));
        this.responseInterceptors.forEach(arg_0 -> ((HttpClientBuilder)httpClientBuilder).addResponseInterceptorLast(arg_0));
        this.closeableHttpClient = httpClientBuilder.build();
        this.prepared.set(true);
    }

    @Override
    public CloseableHttpClient build() {
        if (!this.prepared.get()) {
            this.prepare();
        }
        return this.closeableHttpClient;
    }

    public AtomicBoolean getPrepared() {
        return this.prepared;
    }

    public int getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public int getIdleConnTimeout() {
        return this.idleConnTimeout;
    }

    public int getCheckWaitTime() {
        return this.checkWaitTime;
    }

    public int getMaxConnPerHost() {
        return this.maxConnPerHost;
    }

    public int getMaxTotalConn() {
        return this.maxTotalConn;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public List<HttpRequestInterceptor> getRequestInterceptors() {
        return this.requestInterceptors;
    }

    public List<HttpResponseInterceptor> getResponseInterceptors() {
        return this.responseInterceptors;
    }

    public HttpRequestRetryStrategy getHttpRequestRetryStrategy() {
        return this.httpRequestRetryStrategy;
    }

    public ConnectionKeepAliveStrategy getConnectionKeepAliveStrategy() {
        return this.connectionKeepAliveStrategy;
    }

    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    public int getHttpProxyPort() {
        return this.httpProxyPort;
    }

    public String getHttpProxyUsername() {
        return this.httpProxyUsername;
    }

    public char[] getHttpProxyPassword() {
        return this.httpProxyPassword;
    }

    public CloseableHttpClient getCloseableHttpClient() {
        return this.closeableHttpClient;
    }

    public void setConnectionRequestTimeout(int connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public void setIdleConnTimeout(int idleConnTimeout) {
        this.idleConnTimeout = idleConnTimeout;
    }

    public void setCheckWaitTime(int checkWaitTime) {
        this.checkWaitTime = checkWaitTime;
    }

    public void setMaxConnPerHost(int maxConnPerHost) {
        this.maxConnPerHost = maxConnPerHost;
    }

    public void setMaxTotalConn(int maxTotalConn) {
        this.maxTotalConn = maxTotalConn;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setRequestInterceptors(List<HttpRequestInterceptor> requestInterceptors) {
        this.requestInterceptors = requestInterceptors;
    }

    public void setResponseInterceptors(List<HttpResponseInterceptor> responseInterceptors) {
        this.responseInterceptors = responseInterceptors;
    }

    public void setHttpRequestRetryStrategy(HttpRequestRetryStrategy httpRequestRetryStrategy) {
        this.httpRequestRetryStrategy = httpRequestRetryStrategy;
    }

    public void setConnectionKeepAliveStrategy(ConnectionKeepAliveStrategy connectionKeepAliveStrategy) {
        this.connectionKeepAliveStrategy = connectionKeepAliveStrategy;
    }

    public void setHttpProxyHost(String httpProxyHost) {
        this.httpProxyHost = httpProxyHost;
    }

    public void setHttpProxyPort(int httpProxyPort) {
        this.httpProxyPort = httpProxyPort;
    }

    public void setHttpProxyUsername(String httpProxyUsername) {
        this.httpProxyUsername = httpProxyUsername;
    }

    public void setHttpProxyPassword(char[] httpProxyPassword) {
        this.httpProxyPassword = httpProxyPassword;
    }

    public void setCloseableHttpClient(CloseableHttpClient closeableHttpClient) {
        this.closeableHttpClient = closeableHttpClient;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultHttpComponentsClientBuilder)) {
            return false;
        }
        DefaultHttpComponentsClientBuilder other = (DefaultHttpComponentsClientBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getConnectionRequestTimeout() != other.getConnectionRequestTimeout()) {
            return false;
        }
        if (this.getConnectionTimeout() != other.getConnectionTimeout()) {
            return false;
        }
        if (this.getSoTimeout() != other.getSoTimeout()) {
            return false;
        }
        if (this.getIdleConnTimeout() != other.getIdleConnTimeout()) {
            return false;
        }
        if (this.getCheckWaitTime() != other.getCheckWaitTime()) {
            return false;
        }
        if (this.getMaxConnPerHost() != other.getMaxConnPerHost()) {
            return false;
        }
        if (this.getMaxTotalConn() != other.getMaxTotalConn()) {
            return false;
        }
        if (this.getHttpProxyPort() != other.getHttpProxyPort()) {
            return false;
        }
        AtomicBoolean this$prepared = this.getPrepared();
        AtomicBoolean other$prepared = other.getPrepared();
        if (this$prepared == null ? other$prepared != null : !this$prepared.equals(other$prepared)) {
            return false;
        }
        String this$userAgent = this.getUserAgent();
        String other$userAgent = other.getUserAgent();
        if (this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent)) {
            return false;
        }
        List<HttpRequestInterceptor> this$requestInterceptors = this.getRequestInterceptors();
        List<HttpRequestInterceptor> other$requestInterceptors = other.getRequestInterceptors();
        if (this$requestInterceptors == null ? other$requestInterceptors != null : !((Object)this$requestInterceptors).equals(other$requestInterceptors)) {
            return false;
        }
        List<HttpResponseInterceptor> this$responseInterceptors = this.getResponseInterceptors();
        List<HttpResponseInterceptor> other$responseInterceptors = other.getResponseInterceptors();
        if (this$responseInterceptors == null ? other$responseInterceptors != null : !((Object)this$responseInterceptors).equals(other$responseInterceptors)) {
            return false;
        }
        HttpRequestRetryStrategy this$httpRequestRetryStrategy = this.getHttpRequestRetryStrategy();
        HttpRequestRetryStrategy other$httpRequestRetryStrategy = other.getHttpRequestRetryStrategy();
        if (this$httpRequestRetryStrategy == null ? other$httpRequestRetryStrategy != null : !this$httpRequestRetryStrategy.equals(other$httpRequestRetryStrategy)) {
            return false;
        }
        ConnectionKeepAliveStrategy this$connectionKeepAliveStrategy = this.getConnectionKeepAliveStrategy();
        ConnectionKeepAliveStrategy other$connectionKeepAliveStrategy = other.getConnectionKeepAliveStrategy();
        if (this$connectionKeepAliveStrategy == null ? other$connectionKeepAliveStrategy != null : !this$connectionKeepAliveStrategy.equals(other$connectionKeepAliveStrategy)) {
            return false;
        }
        String this$httpProxyHost = this.getHttpProxyHost();
        String other$httpProxyHost = other.getHttpProxyHost();
        if (this$httpProxyHost == null ? other$httpProxyHost != null : !this$httpProxyHost.equals(other$httpProxyHost)) {
            return false;
        }
        String this$httpProxyUsername = this.getHttpProxyUsername();
        String other$httpProxyUsername = other.getHttpProxyUsername();
        if (this$httpProxyUsername == null ? other$httpProxyUsername != null : !this$httpProxyUsername.equals(other$httpProxyUsername)) {
            return false;
        }
        if (!Arrays.equals(this.getHttpProxyPassword(), other.getHttpProxyPassword())) {
            return false;
        }
        CloseableHttpClient this$closeableHttpClient = this.getCloseableHttpClient();
        CloseableHttpClient other$closeableHttpClient = other.getCloseableHttpClient();
        return !(this$closeableHttpClient == null ? other$closeableHttpClient != null : !this$closeableHttpClient.equals(other$closeableHttpClient));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultHttpComponentsClientBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getConnectionRequestTimeout();
        result = result * 59 + this.getConnectionTimeout();
        result = result * 59 + this.getSoTimeout();
        result = result * 59 + this.getIdleConnTimeout();
        result = result * 59 + this.getCheckWaitTime();
        result = result * 59 + this.getMaxConnPerHost();
        result = result * 59 + this.getMaxTotalConn();
        result = result * 59 + this.getHttpProxyPort();
        AtomicBoolean $prepared = this.getPrepared();
        result = result * 59 + ($prepared == null ? 43 : $prepared.hashCode());
        String $userAgent = this.getUserAgent();
        result = result * 59 + ($userAgent == null ? 43 : $userAgent.hashCode());
        List<HttpRequestInterceptor> $requestInterceptors = this.getRequestInterceptors();
        result = result * 59 + ($requestInterceptors == null ? 43 : ((Object)$requestInterceptors).hashCode());
        List<HttpResponseInterceptor> $responseInterceptors = this.getResponseInterceptors();
        result = result * 59 + ($responseInterceptors == null ? 43 : ((Object)$responseInterceptors).hashCode());
        HttpRequestRetryStrategy $httpRequestRetryStrategy = this.getHttpRequestRetryStrategy();
        result = result * 59 + ($httpRequestRetryStrategy == null ? 43 : $httpRequestRetryStrategy.hashCode());
        ConnectionKeepAliveStrategy $connectionKeepAliveStrategy = this.getConnectionKeepAliveStrategy();
        result = result * 59 + ($connectionKeepAliveStrategy == null ? 43 : $connectionKeepAliveStrategy.hashCode());
        String $httpProxyHost = this.getHttpProxyHost();
        result = result * 59 + ($httpProxyHost == null ? 43 : $httpProxyHost.hashCode());
        String $httpProxyUsername = this.getHttpProxyUsername();
        result = result * 59 + ($httpProxyUsername == null ? 43 : $httpProxyUsername.hashCode());
        result = result * 59 + Arrays.hashCode(this.getHttpProxyPassword());
        CloseableHttpClient $closeableHttpClient = this.getCloseableHttpClient();
        result = result * 59 + ($closeableHttpClient == null ? 43 : $closeableHttpClient.hashCode());
        return result;
    }

    public String toString() {
        return "DefaultHttpComponentsClientBuilder(prepared=" + this.getPrepared() + ", connectionRequestTimeout=" + this.getConnectionRequestTimeout() + ", connectionTimeout=" + this.getConnectionTimeout() + ", soTimeout=" + this.getSoTimeout() + ", idleConnTimeout=" + this.getIdleConnTimeout() + ", checkWaitTime=" + this.getCheckWaitTime() + ", maxConnPerHost=" + this.getMaxConnPerHost() + ", maxTotalConn=" + this.getMaxTotalConn() + ", userAgent=" + this.getUserAgent() + ", requestInterceptors=" + this.getRequestInterceptors() + ", responseInterceptors=" + this.getResponseInterceptors() + ", httpRequestRetryStrategy=" + this.getHttpRequestRetryStrategy() + ", connectionKeepAliveStrategy=" + this.getConnectionKeepAliveStrategy() + ", httpProxyHost=" + this.getHttpProxyHost() + ", httpProxyPort=" + this.getHttpProxyPort() + ", httpProxyUsername=" + this.getHttpProxyUsername() + ", httpProxyPassword=" + Arrays.toString(this.getHttpProxyPassword()) + ", closeableHttpClient=" + this.getCloseableHttpClient() + ")";
    }

    private static class SingletonHolder {
        private static final DefaultHttpComponentsClientBuilder INSTANCE = new DefaultHttpComponentsClientBuilder();

        private SingletonHolder() {
        }
    }
}

