/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.http.hc;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.SimplePostRequestExecutor;
import me.chanjar.weixin.common.util.http.hc.Utf8ResponseHandler;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.io.entity.StringEntity;

public class HttpComponentsSimplePostRequestExecutor
extends SimplePostRequestExecutor<CloseableHttpClient, HttpHost> {
    public HttpComponentsSimplePostRequestExecutor(RequestHttp<CloseableHttpClient, HttpHost> requestHttp) {
        super(requestHttp);
    }

    @Override
    public String execute(String uri, String postEntity, WxType wxType) throws WxErrorException, IOException {
        HttpPost httpPost = new HttpPost(uri);
        if (this.requestHttp.getRequestHttpProxy() != null) {
            RequestConfig config = RequestConfig.custom().setProxy((HttpHost)this.requestHttp.getRequestHttpProxy()).build();
            httpPost.setConfig(config);
        }
        if (postEntity != null) {
            StringEntity entity = new StringEntity(postEntity, ContentType.APPLICATION_JSON.withCharset(StandardCharsets.UTF_8));
            httpPost.setEntity((HttpEntity)entity);
        }
        String responseContent = (String)((CloseableHttpClient)this.requestHttp.getRequestHttpClient()).execute((ClassicHttpRequest)httpPost, Utf8ResponseHandler.INSTANCE);
        return this.handleResponse(wxType, responseContent);
    }
}

