/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.json;

import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.apache.commons.lang3.BooleanUtils;

public class WxBooleanTypeAdapter
extends TypeAdapter<Boolean> {
    public void write(JsonWriter out, Boolean value) throws IOException {
        if (value == null) {
            out.nullValue();
        } else {
            out.value(value);
        }
    }

    public Boolean read(JsonReader in) throws IOException {
        JsonToken peek = in.peek();
        switch (peek) {
            case BOOLEAN: {
                return in.nextBoolean();
            }
            case NULL: {
                in.nextNull();
                return null;
            }
            case NUMBER: {
                return BooleanUtils.toBoolean((int)in.nextInt());
            }
            case STRING: {
                return BooleanUtils.toBoolean((String)in.nextString());
            }
        }
        throw new JsonParseException("Expected BOOLEAN or NUMBER but was " + peek);
    }
}

