/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaOpenApiService;
import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.openapi.WxMiniGetApiQuotaResult;
import cn.binarywang.wx.miniapp.bean.openapi.WxMiniGetRidInfoResult;
import cn.binarywang.wx.miniapp.json.WxMaGsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonParser;

public class WxMaOpenApiServiceImpl
implements WxMaOpenApiService {
    private final WxMaService wxMaService;
    private static final String REQUEST = "request";

    @Override
    public boolean clearQuota() throws WxErrorException {
        JsonObject params = new JsonObject();
        params.addProperty("appid", this.wxMaService.getWxMaConfig().getAppid());
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/cgi-bin/clear_quota", params.toString());
        this.parseErrorResponse(responseContent);
        return true;
    }

    @Override
    public WxMiniGetApiQuotaResult getApiQuota(String cgiPath) throws WxErrorException {
        JsonObject params = new JsonObject();
        params.addProperty("cgi_path", cgiPath);
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/cgi-bin/openapi/quota/get", params.toString());
        this.parseErrorResponse(responseContent);
        return (WxMiniGetApiQuotaResult)WxMaGsonBuilder.create().fromJson((JsonElement)GsonParser.parse((String)responseContent), WxMiniGetApiQuotaResult.class);
    }

    @Override
    public WxMiniGetRidInfoResult getRidInfo(String rid) throws WxErrorException {
        JsonObject params = new JsonObject();
        params.addProperty("rid", rid);
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/cgi-bin/openapi/rid/get", params.toString());
        this.parseErrorResponse(responseContent);
        JsonObject response = GsonParser.parse((String)responseContent);
        if (response.has(REQUEST)) {
            return (WxMiniGetRidInfoResult)WxMaGsonBuilder.create().fromJson((JsonElement)response.getAsJsonObject(REQUEST), WxMiniGetRidInfoResult.class);
        }
        return null;
    }

    @Override
    public boolean clearQuotaByAppSecret() throws WxErrorException {
        String url = String.format("https://api.weixin.qq.com/cgi-bin/clear_quota/v2?appid=%s&appsecret=%s", this.wxMaService.getWxMaConfig().getAppid(), this.wxMaService.getWxMaConfig().getSecret());
        String responseContent = this.wxMaService.post(url, "");
        this.parseErrorResponse(responseContent);
        return true;
    }

    private void parseErrorResponse(String response) throws WxErrorException {
        JsonObject jsonObject = GsonParser.parse((String)response);
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)response, (WxType)WxType.MiniApp));
        }
    }

    public WxMaOpenApiServiceImpl(WxMaService wxMaService) {
        this.wxMaService = wxMaService;
    }
}

