/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.executor;

import cn.binarywang.wx.miniapp.bean.AbstractWxMaQrcodeWrapper;
import cn.binarywang.wx.miniapp.executor.ApacheQrcodeFileRequestExecutor;
import cn.binarywang.wx.miniapp.executor.HttpComponentsQrcodeFileRequestExecutor;
import cn.binarywang.wx.miniapp.executor.OkHttpQrcodeFileRequestExecutor;
import java.io.File;
import java.io.IOException;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.ResponseHandler;

public abstract class QrcodeRequestExecutor<H, P>
implements RequestExecutor<File, AbstractWxMaQrcodeWrapper> {
    protected RequestHttp<H, P> requestHttp;

    protected QrcodeRequestExecutor(RequestHttp<H, P> requestHttp) {
        this.requestHttp = requestHttp;
    }

    public void execute(String uri, AbstractWxMaQrcodeWrapper data, ResponseHandler<File> handler, WxType wxType) throws WxErrorException, IOException {
        handler.handle(this.execute(uri, data, wxType));
    }

    public static RequestExecutor<File, AbstractWxMaQrcodeWrapper> create(RequestHttp<?, ?> requestHttp, String path) {
        switch (requestHttp.getRequestType()) {
            case APACHE_HTTP: {
                return new ApacheQrcodeFileRequestExecutor(requestHttp, path);
            }
            case OK_HTTP: {
                return new OkHttpQrcodeFileRequestExecutor(requestHttp, path);
            }
            case HTTP_COMPONENTS: {
                return new HttpComponentsQrcodeFileRequestExecutor(requestHttp, path);
            }
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684http\u6267\u884c\u5668\u7c7b\u578b\uff1a" + requestHttp.getRequestType());
    }

    public static RequestExecutor<File, AbstractWxMaQrcodeWrapper> create(RequestHttp<?, ?> requestHttp) {
        switch (requestHttp.getRequestType()) {
            case APACHE_HTTP: {
                return new ApacheQrcodeFileRequestExecutor(requestHttp, null);
            }
            case OK_HTTP: {
                return new OkHttpQrcodeFileRequestExecutor(requestHttp, null);
            }
            case HTTP_COMPONENTS: {
                return new HttpComponentsQrcodeFileRequestExecutor(requestHttp, null);
            }
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684http\u6267\u884c\u5668\u7c7b\u578b\uff1a" + requestHttp.getRequestType());
    }
}

