/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects;

public class DDLFormatter {
    private static boolean isSpace(char c) {
        return c <= ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    public static String format(String template) {
        StringBuilder sb = new StringBuilder();
        char[] chars = ("  " + template + "  ").toCharArray();
        int inBrackets = 0;
        boolean justReturned = false;
        for (int i = 2; i < chars.length - 2; ++i) {
            char c = chars[i];
            if (DDLFormatter.isSpace(c)) {
                if (justReturned) continue;
                sb.append(c);
                continue;
            }
            if (c == '(') {
                sb.append(c);
                if (inBrackets == 0) {
                    sb.append("\n");
                    justReturned = true;
                }
                ++inBrackets;
                continue;
            }
            if (c == ')') {
                if (--inBrackets == 0) {
                    sb.append("\n");
                    justReturned = true;
                }
                sb.append(c);
                continue;
            }
            if (c == ',') {
                sb.append(c);
                if (inBrackets != 1) continue;
                sb.append("\n");
                justReturned = true;
                continue;
            }
            sb.append(c);
            justReturned = false;
        }
        return sb.toString();
    }
}

