/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects;

import com.github.drinkjava2.jdialects.StrUtils;

public interface NamingConversion {
    public static final NamingConversion NONE = null;
    public static final NamingConversion LOWER_CASE_UNDERSCORE = new LowerCaseUnderscoreConversion();
    public static final NamingConversion UPPER_CASE_UNDERSCORE = new UpperCaseUnderscoreConversion();

    public String getTableName(Class<?> var1);

    public String getColumnName(String var1);

    public static class UpperCaseUnderscoreConversion
    implements NamingConversion {
        @Override
        public String getTableName(Class<?> clazz) {
            return StrUtils.camelToLowerCaseUnderScore(clazz.getSimpleName()).toUpperCase();
        }

        @Override
        public String getColumnName(String entityField) {
            return StrUtils.camelToLowerCaseUnderScore(entityField).toUpperCase();
        }
    }

    public static class LowerCaseUnderscoreConversion
    implements NamingConversion {
        @Override
        public String getTableName(Class<?> clazz) {
            return StrUtils.camelToLowerCaseUnderScore(clazz.getSimpleName());
        }

        @Override
        public String getColumnName(String entityField) {
            return StrUtils.camelToLowerCaseUnderScore(entityField);
        }
    }
}

