/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects;

import java.util.HashSet;
import java.util.Set;

public class SqlFormatter {
    private static final Set<String> keywords = new HashSet<String>();

    private static boolean isSpace(char c) {
        return c <= ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    public static String format(String template) {
        StringBuilder sb = new StringBuilder();
        char[] chars = ("  " + template + "  ").toCharArray();
        boolean inStr = false;
        boolean justAddedSpace = true;
        StringBuilder lastWord = new StringBuilder();
        for (int i = 2; i < chars.length - 2; ++i) {
            char c = chars[i];
            if (SqlFormatter.isSpace(c)) {
                if (inStr) {
                    sb.append(c);
                    continue;
                }
                if (justAddedSpace) continue;
                SqlFormatter.addLast(sb, lastWord);
                sb.append(' ');
                justAddedSpace = true;
                continue;
            }
            if (c == '\'') {
                if (!inStr) {
                    SqlFormatter.addLast(sb, lastWord);
                }
                sb.append('\'');
                inStr = !inStr;
                justAddedSpace = false;
                continue;
            }
            justAddedSpace = false;
            if (inStr) {
                sb.append(c);
                continue;
            }
            lastWord.append(c);
        }
        SqlFormatter.addLast(sb, lastWord);
        return sb.toString();
    }

    private static void addLast(StringBuilder sb, StringBuilder lastWord) {
        if (lastWord.length() == 0) {
            return;
        }
        String last = lastWord.toString();
        if (sb.length() > 0 && keywords.contains(last.toLowerCase())) {
            sb.append("\n");
        }
        sb.append(last);
        lastWord.setLength(0);
    }

    static {
        keywords.add("select");
        keywords.add("insert");
        keywords.add("update");
        keywords.add("delete");
        keywords.add("create");
        keywords.add("drop");
        keywords.add("alter");
        keywords.add("from");
        keywords.add("in");
        keywords.add("exists");
        keywords.add("where");
        keywords.add("order");
        keywords.add("group");
        keywords.add("union");
        keywords.add("inner");
        keywords.add("left");
        keywords.add("right");
        keywords.add("outer");
    }
}

