/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects;

import com.github.drinkjava2.jdialects.Dialect;
import com.github.drinkjava2.jdialects.StrUtils;
import com.github.drinkjava2.jdialects.TableModelUtilsOfDb;
import com.github.drinkjava2.jdialects.TableModelUtilsOfEntity;
import com.github.drinkjava2.jdialects.TableModelUtilsOfExcel;
import com.github.drinkjava2.jdialects.TableModelUtilsOfJavaSrc;
import com.github.drinkjava2.jdialects.model.TableModel;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.sql.DataSource;

public abstract class TableModelUtils {
    public static final String OPT_EXCLUDE_TABLES = "excludeTables";
    public static final String OPT_PACKAGE_NAME = "packageName";
    public static final String OPT_IMPORTS = "imports";
    public static final String OPT_REMOVE_DEFAULT_IMPORTS = "removeDefaultImports";
    public static final String OPT_CLASS_ANNOTATION = "classAnnotationn";
    public static final String OPT_CLASS_DEFINITION = "classDefinition";
    public static final String OPT_FIELD_FLAGS_STATIC = "fieldFlagsStatic";
    public static final String OPT_FIELD_FLAGS = "fieldFlags";
    public static final String OPT_FIELD_FLAGS_STYLE = "fieldFlagsStyle";
    public static final String OPT_PUBLIC_FIELD = "enablePublicField";
    public static final String OPT_FIELDS = "fields";
    public static final String OPT_GETTER_SETTERS = "getterSetters";
    public static final String OPT_LINK_STYLE = "linkStyle";

    public static Class<?> tableNameToEntityClass(String tableName) {
        return TableModelUtilsOfEntity.tableNameToEntityClass(tableName);
    }

    public static TableModel entity2Model(Class<?> entityClass) {
        return TableModelUtilsOfEntity.entity2EditableModel(entityClass);
    }

    public static TableModel[] entity2Models(Class<?> ... entityClasses) {
        return TableModelUtilsOfEntity.entity2EditableModels(entityClasses);
    }

    public static TableModel entity2ReadOnlyModel(Class<?> entityClass) {
        return TableModelUtilsOfEntity.entity2ReadOnlyModel(entityClass);
    }

    public static TableModel[] entity2ReadOnlyModels(Class<?> ... entityClasses) {
        return TableModelUtilsOfEntity.entity2ReadOnlyModel(entityClasses);
    }

    public static TableModel[] db2Models(Connection con, Dialect dialect) {
        return TableModelUtilsOfDb.db2Models(con, dialect);
    }

    public static void db2JavaSrcFiles(DataSource ds, Dialect dialect, String outputfolder, Map<String, Object> setting) {
        block8: {
            Connection conn = null;
            try {
                HashSet<String> excludeTables;
                conn = ds.getConnection();
                TableModel[] models = TableModelUtils.db2Models(conn, dialect);
                File dir = new File(outputfolder);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                if ((excludeTables = (HashSet<String>)setting.get(OPT_EXCLUDE_TABLES)) != null) {
                    HashSet<String> t = new HashSet<String>();
                    for (String s : excludeTables) {
                        t.add(s.trim().toLowerCase());
                    }
                    excludeTables = t;
                }
                for (TableModel model : models) {
                    String tableName = model.getTableName();
                    if (excludeTables != null && excludeTables.contains(tableName.toLowerCase())) continue;
                    String filePrefix = (String)setting.get(OPT_CLASS_DEFINITION);
                    filePrefix = StrUtils.substringBefore(filePrefix, "$");
                    filePrefix = StrUtils.substringAfterLast(filePrefix, " ");
                    File writename = new File(dir, filePrefix + TableModelUtilsOfJavaSrc.getClassNameFromTableModel(model) + ".java");
                    writename.createNewFile();
                    BufferedWriter out = new BufferedWriter(new FileWriter(writename));
                    String javaSrc = TableModelUtils.model2JavaSrc(model, setting);
                    out.write(javaSrc);
                    out.flush();
                    out.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (conn == null) break block8;
                try {
                    conn.close();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public static void db2QClassSrcFiles(DataSource ds, Dialect dialect, String outputFolder, String packageName, String prefix) {
        HashMap<String, Object> setting = new HashMap<String, Object>();
        setting.put(OPT_PACKAGE_NAME, packageName);
        setting.put(OPT_REMOVE_DEFAULT_IMPORTS, true);
        setting.put(OPT_CLASS_ANNOTATION, false);
        setting.put(OPT_CLASS_DEFINITION, "public class " + prefix + "$Class {\n\tpublic static final " + prefix + "$Class instance = new " + prefix + "$Class();\n\n\tpublic String toString(){\n\t\treturn \"$table\";\n\t}\n");
        setting.put(OPT_FIELD_FLAGS, true);
        setting.put(OPT_FIELD_FLAGS_STATIC, false);
        setting.put(OPT_FIELD_FLAGS_STYLE, "normal");
        setting.put(OPT_FIELDS, false);
        TableModelUtils.db2JavaSrcFiles(ds, dialect, outputFolder, setting);
    }

    public static String model2JavaSrc(TableModel model, Map<String, Object> setting) {
        return TableModelUtilsOfJavaSrc.modelToJavaSourceCode(model, setting);
    }

    public static void bindGlobalModel(Class<?> entityClass, TableModel tableModel) {
        TableModelUtilsOfEntity.globalTableModelCache.put(entityClass, tableModel);
    }

    public static void entityPackage2Excel(String pkgName, String fileName) {
        TableModelUtilsOfExcel.entityPackage2Excel(pkgName, fileName);
    }

    public static void entity2Excel(String fileName, Class<?> ... entityClasses) {
        TableModelUtilsOfExcel.model2Excel(fileName, TableModelUtils.entity2Models(entityClasses));
    }

    public static void db2Excel(Connection con, Dialect dialect, String fileName) {
        TableModel[] models = TableModelUtilsOfDb.db2Models(con, dialect);
        TableModelUtilsOfExcel.model2Excel(fileName, models);
    }
}

