/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects.model;

import com.github.drinkjava2.jdialects.DialectException;
import com.github.drinkjava2.jdialects.model.TableModel;

public class IndexModel {
    private String name;
    private String[] columnList;
    private Boolean unique = false;
    private TableModel tableModel;

    public IndexModel() {
    }

    public IndexModel(String name) {
        this.name = name;
    }

    public IndexModel newCopy() {
        IndexModel result = new IndexModel();
        result.name = this.name;
        result.columnList = this.columnList;
        result.unique = this.unique;
        return result;
    }

    public IndexModel columns(String ... columns) {
        this.checkReadOnly();
        this.columnList = columns;
        return this;
    }

    public IndexModel unique() {
        this.checkReadOnly();
        this.unique = true;
        return this;
    }

    public void checkReadOnly() {
        if (this.tableModel != null && this.tableModel.getReadOnly().booleanValue()) {
            throw new DialectException("TableModel '" + this.tableModel.getTableName() + "' is readOnly, can not be modified.");
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.checkReadOnly();
        this.name = name;
    }

    public String[] getColumnList() {
        return this.columnList;
    }

    public void setColumnList(String[] columnList) {
        this.checkReadOnly();
        this.columnList = columnList;
    }

    public Boolean getUnique() {
        return this.unique;
    }

    public void setUnique(Boolean unique) {
        this.checkReadOnly();
        this.unique = unique;
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(TableModel tableModel) {
        this.checkReadOnly();
        this.tableModel = tableModel;
    }
}

