/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.datastructures.streams;

import com.github.fppt.jedismock.datastructures.streams.SequencedMapForwardIterator;
import com.github.fppt.jedismock.datastructures.streams.SequencedMapReverseIterator;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public class SequencedMap<K extends Comparable<K>, V>
implements Iterable<Map.Entry<K, V>> {
    private final Map<K, LinkedMapNode> map = new HashMap<K, LinkedMapNode>();
    private K tail;
    private K head;
    private int size = 0;

    public void append(K key, V value) {
        if (this.size == 0) {
            this.head = key;
        } else {
            this.map.get(this.tail).setNext(key);
        }
        this.map.put(key, new LinkedMapNode(value).setPrev(this.tail));
        ++this.size;
        this.tail = key;
    }

    public Map.Entry<K, V> remove(K key) {
        if (!this.map.containsKey(key)) {
            return null;
        }
        if (this.size == 1) {
            this.size = 0;
            this.tail = null;
            this.head = null;
            return new AbstractMap.SimpleEntry(key, this.map.remove(key).value);
        }
        if (key.equals(this.tail)) {
            this.tail = this.getPreviousKey(key);
            this.map.get(this.tail).next = null;
        } else if (key.equals(this.head)) {
            this.head = this.getNextKey(key);
            this.map.get(this.head).prev = null;
        } else {
            this.setNextKey(this.getPreviousKey(key), this.getNextKey(key));
            this.setPreviousKey(this.getNextKey(key), this.getPreviousKey(key));
        }
        --this.size;
        return new AbstractMap.SimpleEntry(key, this.map.remove(key).value);
    }

    public void removeHead() {
        if (this.size == 0) {
            return;
        }
        --this.size;
        this.head = this.getNextKey(this.head);
    }

    public V get(K key) {
        LinkedMapNode node = this.map.get(key);
        if (node == null) {
            return null;
        }
        return node.value;
    }

    public int size() {
        return this.size;
    }

    K getNextKey(K key) {
        return this.map.get(key).next;
    }

    void setNextKey(K key, K next) {
        if (!this.map.containsKey(next) || !this.map.containsKey(key)) {
            throw new NullPointerException("Map does not contain some of provided keys");
        }
        this.map.get(key).next = next;
    }

    public K getPreviousKey(K key) {
        return this.map.get(key).prev;
    }

    public void setPreviousKey(K key, K prev) {
        if (!this.map.containsKey(prev) || !this.map.containsKey(key)) {
            throw new NullPointerException("Map does not contain some of provided keys");
        }
        this.map.get(key).prev = prev;
    }

    public boolean contains(K key) {
        return this.map.containsKey(key);
    }

    public K getHead() {
        return this.head;
    }

    public K getTail() {
        return this.tail;
    }

    public SequencedMapForwardIterator<K, V> iterator() {
        return new SequencedMapForwardIterator(this.head, this);
    }

    public SequencedMapForwardIterator<K, V> iterator(K key) {
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        if (this.map.containsKey(key)) {
            return new SequencedMapForwardIterator(key, this);
        }
        Comparable startKey = null;
        SequencedMapForwardIterator it = new SequencedMapForwardIterator(null, this);
        if (key != this.head) {
            while (it.hasNext() && (startKey = (Comparable)it.next().getKey()).compareTo(key) < 0) {
            }
        }
        if (startKey != null) {
            it.stepBack();
        }
        return it;
    }

    public SequencedMapReverseIterator<K, V> reverseIterator() {
        return new SequencedMapReverseIterator(this.tail, this);
    }

    public SequencedMapReverseIterator<K, V> reverseIterator(K key) {
        if (key == null) {
            throw new NullPointerException("Key is null");
        }
        if (this.map.containsKey(key)) {
            return new SequencedMapReverseIterator(key, this);
        }
        Comparable startKey = null;
        SequencedMapReverseIterator it = new SequencedMapReverseIterator(null, this);
        if (key != this.tail) {
            while (it.hasNext() && (startKey = (Comparable)it.next().getKey()).compareTo(key) > 0) {
            }
        }
        if (startKey != null) {
            it.stepBack();
        }
        return it;
    }

    public void forEach(BiConsumer<? super K, ? super V> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.size == 0) {
            return;
        }
        K currKey = this.head;
        do {
            action.accept(currKey, this.map.get(currKey).value);
        } while ((currKey = this.map.get(currKey).next) != null);
    }

    protected class LinkedMapNode {
        protected final V value;
        protected K next;
        protected K prev;

        LinkedMapNode(V value) {
            this.value = value;
        }

        public LinkedMapNode setNext(K next) {
            this.next = next;
            return this;
        }

        public LinkedMapNode setPrev(K prev) {
            this.prev = prev;
            return this;
        }
    }
}

