/*
 * Decompiled with CFR 0.152.
 */
package com.jpay.secure;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;

public class RSAUtils {
    private static final int MAX_ENCRYPT_BLOCK = 117;
    private static final int MAX_DECRYPT_BLOCK = 128;
    private static final String KEY_ALGORITHM = "RSA";
    static final Base64 base64 = new Base64();

    public static Map<String, String> getKeys() throws Exception {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        keyPairGen.initialize(1024);
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        String publicKeyStr = RSAUtils.getPublicKeyStr(publicKey);
        String privateKeyStr = RSAUtils.getPrivateKeyStr(privateKey);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("publicKey", publicKeyStr);
        map.put("privateKey", privateKeyStr);
        System.out.println("\u516c\u94a5\r\n" + publicKeyStr);
        System.out.println("\u79c1\u94a5\r\n" + privateKeyStr);
        return map;
    }

    public static RSAPublicKey getPublicKey(String modulus, String exponent) {
        try {
            BigInteger b1 = new BigInteger(modulus);
            BigInteger b2 = new BigInteger(exponent);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(b1, b2);
            return (RSAPublicKey)keyFactory.generatePublic(keySpec);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static RSAPrivateKey getPrivateKey(String modulus, String exponent) {
        try {
            BigInteger b1 = new BigInteger(modulus);
            BigInteger b2 = new BigInteger(exponent);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            RSAPrivateKeySpec keySpec = new RSAPrivateKeySpec(b1, b2);
            return (RSAPrivateKey)keyFactory.generatePrivate(keySpec);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String encryptByPublicKey(String data, String publicKey) throws Exception {
        return RSAUtils.encryptByPublicKey(data, publicKey, "RSA/ECB/PKCS1Padding");
    }

    public static String encryptByPublicKeyByWx(String data, String publicKey) throws Exception {
        return RSAUtils.encryptByPublicKey(data, publicKey, "RSA/ECB/OAEPWITHSHA-1ANDMGF1PADDING");
    }

    public static String encryptByPublicKey(String data, String publicKey, String fillMode) throws Exception {
        byte[] dataByte = data.getBytes();
        byte[] keyBytes = base64.decode(publicKey);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PublicKey publicK = keyFactory.generatePublic(x509KeySpec);
        Cipher cipher = Cipher.getInstance(fillMode);
        cipher.init(1, publicK);
        int inputLen = dataByte.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(dataByte, offSet, 117) : cipher.doFinal(dataByte, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * 117;
        }
        byte[] encryptedData = out.toByteArray();
        out.close();
        return base64.encodeToString(encryptedData);
    }

    public static String decryptByPrivateKey(String data, String privateKey) throws Exception {
        return RSAUtils.decryptByPrivateKey(data, privateKey, "RSA/ECB/PKCS1Padding");
    }

    public static String decryptByPrivateKeyByWx(String data, String privateKey) throws Exception {
        return RSAUtils.decryptByPrivateKey(data, privateKey, "RSA/ECB/OAEPWITHSHA-1ANDMGF1PADDING");
    }

    public static String decryptByPrivateKey(String data, String privateKey, String fillMode) throws Exception {
        byte[] encryptedData = base64.decode(data);
        byte[] keyBytes = base64.decode(privateKey);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey privateK = keyFactory.generatePrivate(pkcs8KeySpec);
        Cipher cipher = Cipher.getInstance(fillMode);
        cipher.init(2, privateK);
        int inputLen = encryptedData.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 128 ? cipher.doFinal(encryptedData, offSet, 128) : cipher.doFinal(encryptedData, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * 128;
        }
        byte[] decryptedData = out.toByteArray();
        out.close();
        return new String(decryptedData);
    }

    public static Map<String, String> getModulusAndKeys() {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            InputStream in = RSAUtils.class.getResourceAsStream("/rsa.properties");
            Properties prop = new Properties();
            prop.load(in);
            String modulus = prop.getProperty("modulus");
            String publicKey = prop.getProperty("publicKey");
            String privateKey = prop.getProperty("privateKey");
            in.close();
            map.put("modulus", modulus);
            map.put("publicKey", publicKey);
            map.put("privateKey", privateKey);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return map;
    }

    public static PublicKey loadPublicKey(String publicKeyStr) throws Exception {
        try {
            byte[] buffer = base64.decode(publicKeyStr);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(buffer);
            return (RSAPublicKey)keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("\u65e0\u6b64\u7b97\u6cd5");
        }
        catch (InvalidKeySpecException e) {
            throw new Exception("\u516c\u94a5\u975e\u6cd5");
        }
        catch (NullPointerException e) {
            throw new Exception("\u516c\u94a5\u6570\u636e\u4e3a\u7a7a");
        }
    }

    public static PrivateKey loadPrivateKey(String privateKeyStr) throws Exception {
        try {
            byte[] buffer = base64.decode(privateKeyStr);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(buffer);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            return (RSAPrivateKey)keyFactory.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("\u65e0\u6b64\u7b97\u6cd5");
        }
        catch (InvalidKeySpecException e) {
            throw new Exception("\u79c1\u94a5\u975e\u6cd5");
        }
        catch (NullPointerException e) {
            throw new Exception("\u79c1\u94a5\u6570\u636e\u4e3a\u7a7a");
        }
    }

    public static String getPrivateKeyStr(PrivateKey privateKey) throws Exception {
        return new String(base64.encode(privateKey.getEncoded()));
    }

    public static String getPublicKeyStr(PublicKey publicKey) throws Exception {
        return new String(base64.encode(publicKey.getEncoded()));
    }

    public static void main(String[] args) throws Exception {
        Map<String, String> keys = RSAUtils.getKeys();
        String publicKey = keys.get("publicKey");
        String privateKey = keys.get("privateKey");
        String content = "\u6211\u662fJaven,I am Javen";
        String encrypt = RSAUtils.encryptByPublicKey(content, publicKey);
        String decrypt = RSAUtils.decryptByPrivateKey(encrypt, privateKey);
        System.out.println("\u52a0\u5bc6\u4e4b\u540e\uff1a" + encrypt);
        System.out.println("\u89e3\u5bc6\u4e4b\u540e\uff1a" + decrypt);
        System.out.println("======\u534e\u4e3d\u7684\u5206\u5272\u7ebf=========");
        content = "\u6211\u662fJaven,I am Javen";
        encrypt = RSAUtils.encryptByPublicKeyByWx(content, publicKey);
        decrypt = RSAUtils.decryptByPrivateKeyByWx(encrypt, privateKey);
        System.out.println("\u52a0\u5bc6\u4e4b\u540e\uff1a" + encrypt);
        System.out.println("\u89e3\u5bc6\u4e4b\u540e\uff1a" + decrypt);
    }
}

