/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.parser;

import com.github.weisj.jsvg.parser.ExternalResourcePolicy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DefaultResourcePolicy
implements ExternalResourcePolicy {
    private static final Logger LOGGER = Logger.getLogger(DefaultResourcePolicy.class.getName());
    static final int FLAG_ALLOW_RELATIVE = 1;
    static final int FLAG_ALLOW_ABSOLUTE = 2;
    static final int FLAG_ALLOW_NON_LOCAL = 4;
    private final int flags;

    DefaultResourcePolicy(int flags) {
        this.flags = flags;
    }

    @Override
    @Nullable
    public URI resolveResourceURI(@Nullable URI baseURI, @NotNull String path) {
        try {
            return this.resolveResourceURI(baseURI, new URI(path));
        }
        catch (URISyntaxException e) {
            LOGGER.info("Failed to resolve URI: " + path);
            return null;
        }
    }

    @Override
    @Nullable
    public URI resolveResourceURI(@Nullable URI baseDocumentUri, @NotNull URI resourceUri) {
        if (resourceUri.isAbsolute()) {
            if ((this.flags & 2) == 0) {
                LOGGER.info(() -> String.format("Rejected URI %s because absolute paths are not allowed", resourceUri));
                return null;
            }
            if (!"file".equals(resourceUri.getScheme()) && (this.flags & 4) == 0) {
                LOGGER.info(() -> String.format("Rejected URI %s because non-local paths are not allowed", resourceUri));
                return null;
            }
            return resourceUri;
        }
        if (baseDocumentUri == null) {
            return null;
        }
        return baseDocumentUri.resolve(resourceUri);
    }
}

