/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.gateway.discover.router;

import com.github.xiaoymin.knife4j.spring.gateway.Knife4jGatewayProperties;
import com.github.xiaoymin.knife4j.spring.gateway.discover.ServiceRouterConvert;
import com.github.xiaoymin.knife4j.spring.gateway.discover.ServiceRouterHolder;
import com.github.xiaoymin.knife4j.spring.gateway.enums.OpenApiVersion;
import com.github.xiaoymin.knife4j.spring.gateway.spec.v2.OpenAPI2Resource;
import com.github.xiaoymin.knife4j.spring.gateway.utils.PathUtils;
import com.github.xiaoymin.knife4j.spring.gateway.utils.ServiceUtils;
import com.github.xiaoymin.knife4j.spring.gateway.utils.StrUtil;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.handler.predicate.PredicateDefinition;
import org.springframework.util.CollectionUtils;

public abstract class AbstactServiceRouterConvert
implements ServiceRouterConvert {
    private static final Logger log = LoggerFactory.getLogger(AbstactServiceRouterConvert.class);

    abstract String convertPathPrefix(Map<String, String> var1);

    abstract Knife4jGatewayProperties.Discover getDiscover();

    protected void parseRouteDefinition(ServiceRouterHolder routerHolder, List<PredicateDefinition> predicateDefinitions, String id, String serviceName) {
        predicateDefinitions.stream().filter(predicateDefinition -> "Path".equalsIgnoreCase(predicateDefinition.getName())).findFirst().ifPresent(predicateDefinition -> this.processRouteDefinition(routerHolder, id, serviceName, (PredicateDefinition)predicateDefinition));
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processRouteDefinition(ServiceRouterHolder routerHolder, String id, String serviceName, PredicateDefinition predicateDefinition) {
        log.debug("serviceId:{},serviceName:{}", (Object)id, (Object)serviceName);
        String pathPrefix = this.convertPathPrefix(predicateDefinition.getArgs());
        log.debug("pathPrefix:{}", (Object)pathPrefix);
        String contextPath = "";
        String groupName = id;
        int order = 0;
        Knife4jGatewayProperties.Discover discover = this.getDiscover();
        String targetUrl = ServiceUtils.getOpenAPIURL(discover, pathPrefix, null);
        Knife4jGatewayProperties.ServiceConfigInfo configInfo = this.getServiceConfigInfo(serviceName);
        if (configInfo != null) {
            order = configInfo.getOrder();
            if (discover.getVersion() == OpenApiVersion.OpenAPI3) {
                contextPath = PathUtils.append(pathPrefix, configInfo.getContextPath());
            } else if (discover.getVersion() == OpenApiVersion.Swagger2 && StrUtil.isNotBlank(configInfo.getContextPath()) && !"/".equals(configInfo.getContextPath())) {
                contextPath = configInfo.getContextPath();
            }
            targetUrl = PathUtils.append(contextPath, ServiceUtils.getOpenAPIURL(discover, "/", null));
            List<String> groupNames = configInfo.getGroupNames();
            if (!CollectionUtils.isEmpty(groupNames)) {
                int sort = order;
                String ctx = contextPath;
                String url = targetUrl;
                groupNames.forEach(name -> routerHolder.add(this.buildOpenApi2Resource(serviceName, ctx, (String)name, sort, PathUtils.append(url, name))));
                return;
            }
            groupName = configInfo.getGroupName();
        } else if (discover.getVersion() == OpenApiVersion.OpenAPI3) {
            contextPath = PathUtils.processContextPath(pathPrefix);
        }
        routerHolder.add(this.buildOpenApi2Resource(serviceName, contextPath, groupName, order, targetUrl));
    }

    private Knife4jGatewayProperties.ServiceConfigInfo getServiceConfigInfo(String serviceName) {
        Map<String, Knife4jGatewayProperties.ServiceConfigInfo> configInfoMap = this.getDiscover().getServiceConfig();
        return configInfoMap.get(serviceName);
    }

    private OpenAPI2Resource buildOpenApi2Resource(String serviceName, String contextPath, String groupName, int order, String targetUrl) {
        return new OpenAPI2Resource(targetUrl, order, true, groupName, contextPath, serviceName);
    }
}

