/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.extension.mapping.base;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.github.yulichang.extension.mapping.config.DeepConfig;
import com.github.yulichang.extension.mapping.relation.Relation;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public interface MPJDeepService<T>
extends IService<T> {
    default public T getByIdDeep(Serializable id) {
        return (T)Relation.mpjGetRelation(this.getById(id), DeepConfig.defaultConfig());
    }

    default public <R> T getByIdDeep(Serializable id, Function<DeepConfig.Builder<T>, DeepConfig.Builder<T>> config) {
        return (T)Relation.mpjGetRelation(this.getById(id), config.apply(DeepConfig.builder()).build());
    }

    default public <R> T getByIdDeep(Serializable id, DeepConfig<T> config) {
        return (T)Relation.mpjGetRelation(this.getById(id), config);
    }

    default public List<T> listByIdsDeep(Collection<? extends Serializable> idList) {
        return Relation.mpjGetRelation(this.listByIds(idList), DeepConfig.defaultConfig());
    }

    default public <R> List<T> listByIdsDeep(Collection<? extends Serializable> idList, Function<DeepConfig.Builder<T>, DeepConfig.Builder<T>> config) {
        return Relation.mpjGetRelation(this.listByIds(idList), config.apply(DeepConfig.builder()).build());
    }

    default public <R> List<T> listByIdsDeep(Collection<? extends Serializable> idList, DeepConfig<T> config) {
        return Relation.mpjGetRelation(this.listByIds(idList), config);
    }

    default public List<T> listByMapDeep(Map<String, Object> columnMap) {
        return Relation.mpjGetRelation(this.listByMap(columnMap), DeepConfig.defaultConfig());
    }

    default public <R> List<T> listByMapDeep(Map<String, Object> columnMap, Function<DeepConfig.Builder<T>, DeepConfig.Builder<T>> config) {
        return Relation.mpjGetRelation(this.listByMap(columnMap), config.apply(DeepConfig.builder()).build());
    }

    default public <R> List<T> listByMapDeep(Map<String, Object> columnMap, DeepConfig<T> config) {
        return Relation.mpjGetRelation(this.listByMap(columnMap), config);
    }

    default public T getOneDeep(Wrapper<T> queryWrapper) {
        return (T)Relation.mpjGetRelation(this.getOne(queryWrapper), DeepConfig.defaultConfig());
    }

    default public <R> T getOneDeep(Wrapper<T> queryWrapper, Function<DeepConfig.Builder<T>, DeepConfig.Builder<T>> config) {
        return (T)Relation.mpjGetRelation(this.getOne(queryWrapper), config.apply(DeepConfig.builder()).build());
    }

    default public <R> T getOneDeep(Wrapper<T> queryWrapper, DeepConfig<T> config) {
        return (T)Relation.mpjGetRelation(this.getOne(queryWrapper), config);
    }

    default public List<T> listDeep(Wrapper<T> queryWrapper) {
        return Relation.mpjGetRelation(this.list(queryWrapper), DeepConfig.defaultConfig());
    }

    default public <R> List<T> listDeep(Wrapper<T> queryWrapper, Function<DeepConfig.Builder<T>, DeepConfig.Builder<T>> config) {
        return Relation.mpjGetRelation(this.list(queryWrapper), config.apply(DeepConfig.builder()).build());
    }

    default public <R> List<T> listDeep(Wrapper<T> queryWrapper, DeepConfig<T> config) {
        return Relation.mpjGetRelation(this.list(queryWrapper), config);
    }

    default public <E extends IPage<T>> E pageDeep(E page, Wrapper<T> queryWrapper) {
        IPage e = this.page(page, queryWrapper);
        Relation.mpjGetRelation(e.getRecords(), DeepConfig.defaultConfig());
        return (E)e;
    }

    default public <R, E extends IPage<T>> E pageDeep(E page, Wrapper<T> queryWrapper, Function<DeepConfig.Builder<T>, DeepConfig.Builder<T>> config) {
        IPage e = this.page(page, queryWrapper);
        Relation.mpjGetRelation(e.getRecords(), config.apply(DeepConfig.builder()).build());
        return (E)e;
    }

    default public <R, E extends IPage<T>> E pageDeep(E page, Wrapper<T> queryWrapper, DeepConfig<T> config) {
        IPage e = this.page(page, queryWrapper);
        Relation.mpjGetRelation(e.getRecords(), config);
        return (E)e;
    }
}

