/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.domain.reference;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import proguard.analysis.cpa.defaults.AbstractWrapperState;
import proguard.analysis.cpa.defaults.LatticeAbstractState;
import proguard.analysis.cpa.interfaces.AbstractState;
import proguard.analysis.cpa.interfaces.ProgramLocationDependent;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCfaEdge;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.domain.reference.JvmReferenceAbstractState;
import proguard.analysis.cpa.jvm.state.JvmAbstractState;
import proguard.analysis.cpa.jvm.state.heap.JvmHeapAbstractState;
import proguard.analysis.cpa.jvm.state.heap.tree.JvmTreeHeapFollowerAbstractState;
import proguard.classfile.MethodSignature;

public class CompositeHeapJvmAbstractState
extends AbstractWrapperState
implements LatticeAbstractState<CompositeHeapJvmAbstractState>,
ProgramLocationDependent<JvmCfaNode, JvmCfaEdge, MethodSignature> {
    public static final int REFERENCE_STATE_INDEX = 0;
    private final List<JvmAbstractState<? extends LatticeAbstractState<? extends AbstractState>>> jvmAbstractStates;

    public CompositeHeapJvmAbstractState(List<JvmAbstractState<? extends LatticeAbstractState<? extends AbstractState>>> jvmAbstractStates) {
        if (!(jvmAbstractStates.get(0) instanceof JvmReferenceAbstractState)) {
            throw new IllegalArgumentException("The abstract state at index 0 must be a reference abstract state");
        }
        this.jvmAbstractStates = jvmAbstractStates;
    }

    public void updateHeapDependence() {
        this.jvmAbstractStates.stream().map(s -> s.getHeap()).filter(JvmTreeHeapFollowerAbstractState.class::isInstance).forEach(h -> ((JvmTreeHeapFollowerAbstractState)h).setPrincipalState((JvmReferenceAbstractState)this.jvmAbstractStates.get(0)));
    }

    public List<JvmAbstractState<? extends LatticeAbstractState<? extends AbstractState>>> getWrappedStates() {
        return this.jvmAbstractStates;
    }

    @Override
    public CompositeHeapJvmAbstractState join(CompositeHeapJvmAbstractState abstractState) {
        if (this.jvmAbstractStates.size() != abstractState.jvmAbstractStates.size()) {
            throw new IllegalArgumentException("Trying to join two abstract state sequences of different lengths");
        }
        ArrayList<JvmAbstractState<? extends LatticeAbstractState<? extends AbstractState>>> resultStates = new ArrayList<JvmAbstractState<? extends LatticeAbstractState<? extends AbstractState>>>(this.jvmAbstractStates.size());
        for (int i = 0; i < this.jvmAbstractStates.size(); ++i) {
            JvmAbstractState<? extends LatticeAbstractState<? extends AbstractState>> state1 = this.jvmAbstractStates.get(i);
            JvmAbstractState<? extends LatticeAbstractState<? extends AbstractState>> state2 = abstractState.jvmAbstractStates.get(i);
            resultStates.add(state1.join((JvmAbstractState)state1.getClass().cast(state2)));
        }
        CompositeHeapJvmAbstractState result = new CompositeHeapJvmAbstractState(resultStates);
        return this.equals(result) ? this : (abstractState.equals(result) ? abstractState : result);
    }

    @Override
    public boolean isLessOrEqual(CompositeHeapJvmAbstractState abstractState) {
        if (this.jvmAbstractStates.size() != abstractState.jvmAbstractStates.size()) {
            throw new IllegalArgumentException("Trying to compare two abstract state sequences of different lengths");
        }
        for (int i = 0; i < this.jvmAbstractStates.size(); ++i) {
            JvmAbstractState<? extends LatticeAbstractState<? extends AbstractState>> state1 = this.jvmAbstractStates.get(i);
            JvmAbstractState<? extends LatticeAbstractState<? extends AbstractState>> state2 = abstractState.jvmAbstractStates.get(i);
            if (state1.isLessOrEqual((JvmAbstractState)state1.getClass().cast(state2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public JvmCfaNode getProgramLocation() {
        return this.jvmAbstractStates.get(0).getProgramLocation();
    }

    @Override
    public void setProgramLocation(JvmCfaNode programLocation) {
        this.jvmAbstractStates.forEach(s -> s.setProgramLocation(programLocation));
    }

    @Override
    public AbstractState getStateByName(String name) {
        switch (name) {
            case "Reference": {
                return this.jvmAbstractStates.get(0);
            }
        }
        return this.jvmAbstractStates.get(this.jvmAbstractStates.size() - 1);
    }

    @Override
    public AbstractState copy() {
        List<JvmAbstractState<? extends LatticeAbstractState<? extends AbstractState>>> newJvmAbstractStates = this.jvmAbstractStates.stream().map(JvmAbstractState::copy).collect(Collectors.toList());
        ListIterator iterator = newJvmAbstractStates.listIterator(1);
        while (iterator.hasNext()) {
            JvmHeapAbstractState heapAbstractState = ((JvmAbstractState)iterator.next()).getHeap();
            if (!(heapAbstractState instanceof JvmTreeHeapFollowerAbstractState)) continue;
            ((JvmTreeHeapFollowerAbstractState)heapAbstractState).setPrincipalState((JvmReferenceAbstractState)newJvmAbstractStates.get(0));
        }
        return new CompositeHeapJvmAbstractState(newJvmAbstractStates);
    }
}

