/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import java.util.List;
import proguard.classfile.Clazz;
import proguard.classfile.visitor.ClassVisitor;
import proguard.util.ClassNameParser;
import proguard.util.ListParser;
import proguard.util.StringMatcher;
import proguard.util.WildcardManager;

public class ClassNameFilter
implements ClassVisitor {
    private final StringMatcher regularExpressionMatcher;
    private final ClassVisitor acceptedClassVisitor;
    private final ClassVisitor rejectedClassVisitor;

    public ClassNameFilter(String regularExpression, ClassVisitor acceptedClassVisitor) {
        this(regularExpression, (WildcardManager)null, acceptedClassVisitor);
    }

    public ClassNameFilter(String regularExpression, WildcardManager wildcardManager, ClassVisitor acceptedClassVisitor) {
        this(regularExpression, wildcardManager, acceptedClassVisitor, null);
    }

    public ClassNameFilter(List regularExpression, ClassVisitor acceptedClassVisitor) {
        this(regularExpression, (WildcardManager)null, acceptedClassVisitor);
    }

    public ClassNameFilter(List regularExpression, WildcardManager wildcardManager, ClassVisitor acceptedClassVisitor) {
        this(regularExpression, wildcardManager, acceptedClassVisitor, null);
    }

    public ClassNameFilter(StringMatcher regularExpressionMatcher, ClassVisitor acceptedClassVisitor) {
        this(regularExpressionMatcher, acceptedClassVisitor, null);
    }

    public ClassNameFilter(String regularExpression, ClassVisitor acceptedClassVisitor, ClassVisitor rejectedClassVisitor) {
        this(regularExpression, null, acceptedClassVisitor, rejectedClassVisitor);
    }

    public ClassNameFilter(String regularExpression, WildcardManager wildcardManager, ClassVisitor acceptedClassVisitor, ClassVisitor rejectedClassVisitor) {
        this(new ListParser(new ClassNameParser(wildcardManager)).parse(regularExpression), acceptedClassVisitor, rejectedClassVisitor);
    }

    public ClassNameFilter(List regularExpression, ClassVisitor acceptedClassVisitor, ClassVisitor rejectedClassVisitor) {
        this(regularExpression, null, acceptedClassVisitor, rejectedClassVisitor);
    }

    public ClassNameFilter(List regularExpression, WildcardManager wildcardManager, ClassVisitor acceptedClassVisitor, ClassVisitor rejectedClassVisitor) {
        this(new ListParser(new ClassNameParser(wildcardManager)).parse(regularExpression), acceptedClassVisitor, rejectedClassVisitor);
    }

    public ClassNameFilter(StringMatcher regularExpressionMatcher, ClassVisitor acceptedClassVisitor, ClassVisitor rejectedClassVisitor) {
        this.regularExpressionMatcher = regularExpressionMatcher;
        this.acceptedClassVisitor = acceptedClassVisitor;
        this.rejectedClassVisitor = rejectedClassVisitor;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
        ClassVisitor delegate = this.getDelegateVisitor(clazz);
        if (delegate != null) {
            clazz.accept(delegate);
        }
    }

    private ClassVisitor getDelegateVisitor(Clazz clazz) {
        return this.regularExpressionMatcher.matches(clazz.getName()) ? this.acceptedClassVisitor : this.rejectedClassVisitor;
    }
}

