/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.ClassPool;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.util.ClassNameParser;
import proguard.util.ListParser;
import proguard.util.StringMatcher;

public class FilteredClassVisitor
implements ClassPoolVisitor {
    private final ClassVisitor classVisitor;
    private final StringMatcher classNameFilter;

    public FilteredClassVisitor(String classNameFilter, ClassVisitor classVisitor) {
        this(classNameFilter == null ? null : new ListParser(new ClassNameParser()).parse(classNameFilter), classVisitor);
    }

    public FilteredClassVisitor(StringMatcher classNameFilter, ClassVisitor classVisitor) {
        this.classVisitor = classVisitor;
        this.classNameFilter = classNameFilter;
    }

    @Override
    public void visitClassPool(ClassPool classPool) {
        if (this.classNameFilter != null) {
            classPool.classesAccept(this.classNameFilter, this.classVisitor);
        }
    }
}

