/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.io.LibraryClassReader;
import proguard.classfile.io.ProgramClassReader;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.ClassPrinter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.io.ClassFilter;
import proguard.io.DataEntry;
import proguard.io.DataEntryReader;
import proguard.io.FileSource;
import proguard.io.JarReader;
import proguard.util.SimpleFeatureNamedProcessable;

public class ClassReader
implements DataEntryReader {
    private static final String MODULE_INFO_CLASS = "module-info.class";
    private final boolean isLibrary;
    private final boolean skipNonPublicLibraryClasses;
    private final boolean skipNonPublicLibraryClassMembers;
    private final boolean ignoreStackMapAttributes;
    private final WarningPrinter warningPrinter;
    private final ClassVisitor classVisitor;

    public ClassReader(boolean isLibrary, boolean skipNonPublicLibraryClasses, boolean skipNonPublicLibraryClassMembers, boolean ignoreStackMapAttributes, WarningPrinter warningPrinter, ClassVisitor classVisitor) {
        this.isLibrary = isLibrary;
        this.skipNonPublicLibraryClasses = skipNonPublicLibraryClasses;
        this.skipNonPublicLibraryClassMembers = skipNonPublicLibraryClassMembers;
        this.ignoreStackMapAttributes = ignoreStackMapAttributes;
        this.warningPrinter = warningPrinter;
        this.classVisitor = classVisitor;
    }

    @Override
    public void read(DataEntry dataEntry) throws IOException {
        try {
            SimpleFeatureNamedProcessable clazz;
            InputStream inputStream = dataEntry.getInputStream();
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            if (this.isLibrary) {
                clazz = new LibraryClass();
                clazz.accept(new LibraryClassReader(dataInputStream, this.skipNonPublicLibraryClasses, this.skipNonPublicLibraryClassMembers));
            } else {
                clazz = new ProgramClass();
                clazz.accept(new ProgramClassReader(dataInputStream, this.ignoreStackMapAttributes));
            }
            String className = clazz.getName();
            if (className != null) {
                String dataEntryName = dataEntry.getName();
                if (!dataEntryName.equals(MODULE_INFO_CLASS) && !dataEntryName.replace(File.pathSeparatorChar, '/').equals(className + ".class") && this.warningPrinter != null) {
                    this.warningPrinter.print(className, "Warning: class [" + dataEntry.getName() + "] unexpectedly contains class [" + ClassUtil.externalClassName(className) + "]");
                }
                clazz.accept(this.classVisitor);
            }
            dataEntry.closeInputStream();
        }
        catch (Exception ex) {
            throw (IOException)new IOException("Can't process class [" + dataEntry.getName() + "] (" + ex.getMessage() + ")").initCause(ex);
        }
    }

    public static void main(String[] args) {
        for (String fileName : args) {
            try {
                DataEntryReader dataEntryReader = new ClassFilter(new ClassReader(false, false, false, false, null, new ClassPrinter()));
                if (fileName.endsWith(".jar") || fileName.endsWith(".zip")) {
                    dataEntryReader = new JarReader(dataEntryReader);
                }
                new FileSource(new File(fileName)).pumpDataEntries(dataEntryReader);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

