/*
 * Decompiled with CFR 0.152.
 */
package com.haoxuer.bigworld.ad.rest.resource;

import com.haoxuer.bigworld.ad.api.apis.AdPositionApi;
import com.haoxuer.bigworld.ad.api.domain.list.AdPositionList;
import com.haoxuer.bigworld.ad.api.domain.page.AdPositionPage;
import com.haoxuer.bigworld.ad.api.domain.request.AdPositionDataRequest;
import com.haoxuer.bigworld.ad.api.domain.request.AdPositionSearchRequest;
import com.haoxuer.bigworld.ad.api.domain.response.AdPositionResponse;
import com.haoxuer.bigworld.ad.data.dao.AdPositionDao;
import com.haoxuer.bigworld.ad.data.entity.AdPosition;
import com.haoxuer.bigworld.ad.rest.convert.AdPositionResponseConvert;
import com.haoxuer.bigworld.ad.rest.convert.AdPositionSimpleConvert;
import com.haoxuer.bigworld.member.rest.conver.PageableConver;
import com.haoxuer.bigworld.tenant.data.entity.Tenant;
import com.haoxuer.bigworld.tenant.util.TenantBeanUtils;
import com.haoxuer.discover.config.utils.ConverResourceUtils;
import com.haoxuer.discover.data.page.Filter;
import com.haoxuer.discover.data.page.Order;
import com.haoxuer.discover.data.page.Page;
import com.haoxuer.discover.data.page.Pageable;
import com.haoxuer.discover.data.rest.core.Conver;
import com.haoxuer.discover.data.utils.FilterUtils;
import com.haoxuer.discover.rest.base.RequestUserTokenPageObject;
import com.haoxuer.discover.rest.base.ResponseList;
import com.haoxuer.discover.rest.base.ResponsePage;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Component
public class AdPositionResource
implements AdPositionApi {
    @Autowired
    private AdPositionDao dataDao;

    @Override
    public AdPositionResponse create(AdPositionDataRequest request) {
        AdPositionResponse result = new AdPositionResponse();
        AdPosition bean = new AdPosition();
        bean.setTenant(Tenant.fromId((Long)request.getTenant()));
        this.handleData(request, bean);
        this.dataDao.save(bean);
        result = new AdPositionResponseConvert().conver(bean);
        return result;
    }

    @Override
    public AdPositionResponse update(AdPositionDataRequest request) {
        AdPositionResponse result = new AdPositionResponse();
        if (request.getId() == null) {
            result.setCode(501);
            result.setMsg("\u65e0\u6548id");
            return result;
        }
        AdPosition bean = this.dataDao.findById(request.getId());
        if (bean == null) {
            result.setCode(502);
            result.setMsg("\u65e0\u6548id");
            return result;
        }
        this.handleData(request, bean);
        result = new AdPositionResponseConvert().conver(bean);
        return result;
    }

    private void handleData(AdPositionDataRequest request, AdPosition bean) {
        TenantBeanUtils.copyProperties((Object)((Object)request), (Object)((Object)bean));
    }

    @Override
    public AdPositionResponse delete(AdPositionDataRequest request) {
        AdPositionResponse result = new AdPositionResponse();
        if (request.getId() == null) {
            result.setCode(501);
            result.setMsg("\u65e0\u6548id");
            return result;
        }
        this.dataDao.deleteById(request.getTenant(), request.getId());
        return result;
    }

    @Override
    public AdPositionResponse view(AdPositionDataRequest request) {
        AdPositionResponse result = new AdPositionResponse();
        AdPosition bean = this.dataDao.findById(request.getTenant(), request.getId());
        if (bean == null) {
            result.setCode(1000);
            result.setMsg("\u65e0\u6548id");
            return result;
        }
        result = new AdPositionResponseConvert().conver(bean);
        return result;
    }

    @Override
    public AdPositionList list(AdPositionSearchRequest request) {
        AdPositionList result = new AdPositionList();
        ArrayList<Filter> filters = new ArrayList<Filter>();
        filters.add(Filter.eq((String)"tenant.id", (Object)request.getTenant()));
        filters.addAll(FilterUtils.getFilters((Object)((Object)request)));
        ArrayList<Order> orders = new ArrayList<Order>();
        if ("asc".equals(request.getSortMethod())) {
            orders.add(Order.asc((String)("" + request.getSortField())));
        } else if ("desc".equals(request.getSortMethod())) {
            orders.add(Order.desc((String)("" + request.getSortField())));
        } else {
            orders.add(Order.desc((String)"id"));
        }
        List organizations = this.dataDao.list(0, request.getSize(), filters, orders);
        AdPositionSimpleConvert convert = new AdPositionSimpleConvert();
        ConverResourceUtils.converList((ResponseList)result, (List)organizations, (Conver)convert);
        return result;
    }

    @Override
    public AdPositionPage search(AdPositionSearchRequest request) {
        AdPositionPage result = new AdPositionPage();
        Pageable pageable = new PageableConver().conver((RequestUserTokenPageObject)request);
        pageable.getFilters().addAll(FilterUtils.getFilters((Object)((Object)request)));
        pageable.getFilters().add(Filter.eq((String)"tenant.id", (Object)request.getTenant()));
        if ("asc".equals(request.getSortMethod())) {
            pageable.getOrders().add(Order.asc((String)("" + request.getSortField())));
        } else if ("desc".equals(request.getSortMethod())) {
            pageable.getOrders().add(Order.desc((String)("" + request.getSortField())));
        } else {
            pageable.getOrders().add(Order.desc((String)"id"));
        }
        Page page = this.dataDao.page(pageable);
        AdPositionSimpleConvert convert = new AdPositionSimpleConvert();
        ConverResourceUtils.converPage((ResponsePage)result, (Page)page, (Conver)convert);
        return result;
    }
}

