/*
 * Decompiled with CFR 0.152.
 */
package com.haoxuer.bigworld.ad.rest.resource;

import com.haoxuer.bigworld.ad.api.apis.AdApi;
import com.haoxuer.bigworld.ad.api.domain.list.AdList;
import com.haoxuer.bigworld.ad.api.domain.page.AdPage;
import com.haoxuer.bigworld.ad.api.domain.request.AdDataRequest;
import com.haoxuer.bigworld.ad.api.domain.request.AdSearchRequest;
import com.haoxuer.bigworld.ad.api.domain.response.AdResponse;
import com.haoxuer.bigworld.ad.data.dao.AdDao;
import com.haoxuer.bigworld.ad.data.dao.AdPositionDao;
import com.haoxuer.bigworld.ad.data.entity.Ad;
import com.haoxuer.bigworld.ad.data.entity.AdPosition;
import com.haoxuer.bigworld.ad.rest.convert.AdResponseConvert;
import com.haoxuer.bigworld.ad.rest.convert.AdSimpleConvert;
import com.haoxuer.bigworld.member.rest.conver.PageableConver;
import com.haoxuer.bigworld.tenant.data.entity.Tenant;
import com.haoxuer.bigworld.tenant.util.TenantBeanUtils;
import com.haoxuer.discover.config.utils.ConverResourceUtils;
import com.haoxuer.discover.data.page.Filter;
import com.haoxuer.discover.data.page.Order;
import com.haoxuer.discover.data.page.Page;
import com.haoxuer.discover.data.page.Pageable;
import com.haoxuer.discover.data.rest.core.Conver;
import com.haoxuer.discover.data.utils.FilterUtils;
import com.haoxuer.discover.rest.base.RequestUserTokenPageObject;
import com.haoxuer.discover.rest.base.ResponseList;
import com.haoxuer.discover.rest.base.ResponsePage;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Component
public class AdResource
implements AdApi {
    @Autowired
    private AdDao dataDao;
    @Autowired
    private AdPositionDao adPositionDao;

    @Override
    public AdResponse create(AdDataRequest request) {
        AdResponse result = new AdResponse();
        Ad bean = new Ad();
        bean.setTenant(Tenant.fromId((Long)request.getTenant()));
        this.handleData(request, bean);
        this.dataDao.save(bean);
        result = new AdResponseConvert().conver(bean);
        return result;
    }

    @Override
    public AdResponse update(AdDataRequest request) {
        AdResponse result = new AdResponse();
        if (request.getId() == null) {
            result.setCode(501);
            result.setMsg("\u65e0\u6548id");
            return result;
        }
        Ad bean = this.dataDao.findById(request.getId());
        if (bean == null) {
            result.setCode(502);
            result.setMsg("\u65e0\u6548id");
            return result;
        }
        this.handleData(request, bean);
        result = new AdResponseConvert().conver(bean);
        return result;
    }

    private void handleData(AdDataRequest request, Ad bean) {
        TenantBeanUtils.copyProperties((Object)((Object)request), (Object)((Object)bean));
        if (request.getAdPosition() != null) {
            bean.setAdPosition(this.adPositionDao.findById(request.getAdPosition()));
        }
    }

    @Override
    public AdResponse delete(AdDataRequest request) {
        AdResponse result = new AdResponse();
        if (request.getId() == null) {
            result.setCode(501);
            result.setMsg("\u65e0\u6548id");
            return result;
        }
        this.dataDao.deleteById(request.getTenant(), request.getId());
        return result;
    }

    @Override
    public AdResponse view(AdDataRequest request) {
        AdResponse result = new AdResponse();
        Ad bean = this.dataDao.findById(request.getTenant(), request.getId());
        if (bean == null) {
            result.setCode(1000);
            result.setMsg("\u65e0\u6548id");
            return result;
        }
        result = new AdResponseConvert().conver(bean);
        return result;
    }

    @Override
    public AdList list(AdSearchRequest request) {
        AdList result = new AdList();
        ArrayList<Filter> filters = new ArrayList<Filter>();
        filters.add(Filter.eq((String)"tenant.id", (Object)request.getTenant()));
        filters.addAll(FilterUtils.getFilters((Object)((Object)request)));
        ArrayList<Order> orders = new ArrayList<Order>();
        if ("asc".equals(request.getSortMethod())) {
            orders.add(Order.asc((String)("" + request.getSortField())));
        } else if ("desc".equals(request.getSortMethod())) {
            orders.add(Order.desc((String)("" + request.getSortField())));
        } else {
            orders.add(Order.desc((String)"id"));
        }
        List ads = this.dataDao.list(0, request.getSize(), filters, orders);
        AdSimpleConvert convert = new AdSimpleConvert();
        ConverResourceUtils.converList((ResponseList)result, (List)ads, (Conver)convert);
        if (ads != null && ads.size() > 0) {
            AdPosition position = ((Ad)((Object)ads.get(0))).getAdPosition();
            if (position.getWidth() == null) {
                position.setHeight(500);
            }
            if (position.getHeight() == null) {
                position.setHeight(250);
            }
            if (position.getHeight() == 0) {
                position.setHeight(250);
            }
            Double rate = position.getWidth().doubleValue() / position.getHeight().doubleValue();
            result.setRate(rate);
            result.setRadius(position.getRadius());
        } else {
            result.setRate(0.618);
            result.setRadius(0);
        }
        return result;
    }

    @Override
    public AdPage search(AdSearchRequest request) {
        AdPage result = new AdPage();
        Pageable pageable = new PageableConver().conver((RequestUserTokenPageObject)request);
        pageable.getFilters().addAll(FilterUtils.getFilters((Object)((Object)request)));
        pageable.getFilters().add(Filter.eq((String)"tenant.id", (Object)request.getTenant()));
        if ("asc".equals(request.getSortMethod())) {
            pageable.getOrders().add(Order.asc((String)("" + request.getSortField())));
        } else if ("desc".equals(request.getSortMethod())) {
            pageable.getOrders().add(Order.desc((String)("" + request.getSortField())));
        } else {
            pageable.getOrders().add(Order.desc((String)"id"));
        }
        Page page = this.dataDao.page(pageable);
        AdSimpleConvert convert = new AdSimpleConvert();
        ConverResourceUtils.converPage((ResponsePage)result, (Page)page, (Conver)convert);
        return result;
    }
}

