/*
 * Decompiled with CFR 0.152.
 */
package com.haoxuer.bigworld.gather.controller.tenant;

import com.haoxuer.bigworld.gather.api.apis.GatherSqlApi;
import com.haoxuer.bigworld.gather.api.domain.list.GatherSimpleList;
import com.haoxuer.bigworld.gather.api.domain.list.GatherSqlList;
import com.haoxuer.bigworld.gather.api.domain.page.GatherSqlPage;
import com.haoxuer.bigworld.gather.api.domain.request.GatherSqlDataRequest;
import com.haoxuer.bigworld.gather.api.domain.request.GatherSqlSearchRequest;
import com.haoxuer.bigworld.gather.api.domain.response.GatherSqlResponse;
import com.haoxuer.bigworld.gather.api.domain.response.MapResponse;
import com.haoxuer.bigworld.member.controller.tenant.BaseTenantRestController;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.authz.annotation.RequiresUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/tenantRest/gathersql"})
@RestController
public class GatherSqlTenantRestController
extends BaseTenantRestController {
    @Autowired
    private GatherSqlApi api;

    @RequiresPermissions(value={"gathersql"})
    @RequestMapping(value={"create"})
    public GatherSqlResponse create(GatherSqlDataRequest request) {
        this.initTenant(request);
        request.setCreator(request.getCreateUser());
        return this.api.create(request);
    }

    @RequiresPermissions(value={"gathersql"})
    @RequestMapping(value={"delete"})
    public GatherSqlResponse delete(GatherSqlDataRequest request) {
        this.initTenant(request);
        GatherSqlResponse result = new GatherSqlResponse();
        try {
            result = this.api.delete(request);
        }
        catch (Exception e) {
            result.setCode(501);
            result.setMsg("\u5220\u9664\u5931\u8d25!");
        }
        return result;
    }

    @RequiresPermissions(value={"gathersql"})
    @RequestMapping(value={"update"})
    public GatherSqlResponse update(GatherSqlDataRequest request) {
        this.initTenant(request);
        return this.api.update(request);
    }

    @RequiresPermissions(value={"gathersql"})
    @RequestMapping(value={"view"})
    public GatherSqlResponse view(GatherSqlDataRequest request) {
        this.initTenant(request);
        return this.api.view(request);
    }

    @RequiresPermissions(value={"gathersql"})
    @RequestMapping(value={"list"})
    public GatherSqlList list(GatherSqlSearchRequest request) {
        this.initTenant(request);
        return this.api.list(request);
    }

    @RequiresPermissions(value={"gathersql"})
    @RequestMapping(value={"search"})
    public GatherSqlPage search(GatherSqlSearchRequest request) {
        this.initTenant(request);
        return this.api.search(request);
    }

    @RequiresUser
    @RequestMapping(value={"listSql"})
    public GatherSimpleList listSql(GatherSqlSearchRequest request) {
        this.initTenant(request);
        return this.api.listSql(request);
    }

    @RequiresUser
    @RequestMapping(value={"oneSql"})
    public MapResponse oneSql(GatherSqlSearchRequest request) {
        this.initTenant(request);
        return this.api.oneSql(request);
    }
}

