/*
 * Decompiled with CFR 0.152.
 */
package com.haoxuer.bigworld.gather.rest.resource;

import com.haoxuer.bigworld.gather.api.apis.GatherSqlApi;
import com.haoxuer.bigworld.gather.api.domain.list.GatherSimpleList;
import com.haoxuer.bigworld.gather.api.domain.list.GatherSqlList;
import com.haoxuer.bigworld.gather.api.domain.page.GatherSqlPage;
import com.haoxuer.bigworld.gather.api.domain.request.GatherSqlDataRequest;
import com.haoxuer.bigworld.gather.api.domain.request.GatherSqlSearchRequest;
import com.haoxuer.bigworld.gather.api.domain.response.GatherSqlResponse;
import com.haoxuer.bigworld.gather.api.domain.response.MapResponse;
import com.haoxuer.bigworld.gather.api.domain.simple.SimpleItem;
import com.haoxuer.bigworld.gather.data.dao.GatherSqlDao;
import com.haoxuer.bigworld.gather.data.entity.GatherSql;
import com.haoxuer.bigworld.gather.data.mapper.GatherSqlMapper;
import com.haoxuer.bigworld.gather.rest.convert.GatherSqlResponseConvert;
import com.haoxuer.bigworld.gather.rest.convert.GatherSqlSimpleConvert;
import com.haoxuer.bigworld.member.data.dao.TenantUserDao;
import com.haoxuer.bigworld.member.rest.conver.PageableConver;
import com.haoxuer.bigworld.tenant.data.entity.Tenant;
import com.haoxuer.bigworld.tenant.util.TenantBeanUtils;
import com.haoxuer.discover.config.utils.ConverResourceUtils;
import com.haoxuer.discover.data.page.Filter;
import com.haoxuer.discover.data.page.Order;
import com.haoxuer.discover.data.page.Page;
import com.haoxuer.discover.data.page.Pageable;
import com.haoxuer.discover.data.rest.core.Conver;
import com.haoxuer.discover.data.utils.FilterUtils;
import com.haoxuer.discover.rest.base.RequestUserTokenPageObject;
import com.haoxuer.discover.rest.base.ResponseList;
import com.haoxuer.discover.rest.base.ResponsePage;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Transactional
@Component
public class GatherSqlResource
implements GatherSqlApi {
    @Autowired
    private GatherSqlDao dataDao;
    @Autowired
    private TenantUserDao creatorDao;
    @Autowired
    private GatherSqlMapper sqlMapper;

    @Override
    public GatherSqlResponse create(GatherSqlDataRequest request) {
        GatherSqlResponse result = new GatherSqlResponse();
        GatherSql temp = (GatherSql)((Object)this.dataDao.one(new Filter[]{Filter.eq((String)"tenant.id", (Object)request.getTenant()), Filter.eq((String)"key", (Object)request.getKey())}));
        if (temp != null) {
            result.setCode(501);
            result.setMsg("\u8be5key\u5df2\u7ecf\u4f7f\u7528\u8fc7\u4e86");
            return result;
        }
        GatherSql bean = new GatherSql();
        bean.setTenant(Tenant.fromId((Long)request.getTenant()));
        this.handleData(request, bean);
        this.dataDao.save(bean);
        result = new GatherSqlResponseConvert().conver(bean);
        return result;
    }

    @Override
    public GatherSqlResponse update(GatherSqlDataRequest request) {
        GatherSqlResponse result = new GatherSqlResponse();
        if (request.getId() == null) {
            result.setCode(501);
            result.setMsg("\u65e0\u6548id");
            return result;
        }
        GatherSql bean = this.dataDao.findById(request.getId());
        if (bean == null) {
            result.setCode(502);
            result.setMsg("\u65e0\u6548id");
            return result;
        }
        this.handleData(request, bean);
        result = new GatherSqlResponseConvert().conver(bean);
        return result;
    }

    private void handleData(GatherSqlDataRequest request, GatherSql bean) {
        TenantBeanUtils.copyProperties((Object)((Object)request), (Object)((Object)bean));
        if (request.getCreator() != null) {
            bean.setCreator(this.creatorDao.findById(request.getCreator()));
        }
    }

    @Override
    public GatherSqlResponse delete(GatherSqlDataRequest request) {
        GatherSqlResponse result = new GatherSqlResponse();
        if (request.getId() == null) {
            result.setCode(501);
            result.setMsg("\u65e0\u6548id");
            return result;
        }
        this.dataDao.deleteById(request.getTenant(), request.getId());
        return result;
    }

    @Override
    public GatherSqlResponse view(GatherSqlDataRequest request) {
        GatherSqlResponse result = new GatherSqlResponse();
        GatherSql bean = this.dataDao.findById(request.getTenant(), request.getId());
        if (bean == null) {
            result.setCode(1000);
            result.setMsg("\u65e0\u6548id");
            return result;
        }
        result = new GatherSqlResponseConvert().conver(bean);
        return result;
    }

    @Override
    public GatherSqlList list(GatherSqlSearchRequest request) {
        GatherSqlList result = new GatherSqlList();
        ArrayList<Filter> filters = new ArrayList<Filter>();
        filters.add(Filter.eq((String)"tenant.id", (Object)request.getTenant()));
        filters.addAll(FilterUtils.getFilters((Object)((Object)request)));
        ArrayList<Order> orders = new ArrayList<Order>();
        if ("asc".equals(request.getSortMethod())) {
            orders.add(Order.asc((String)("" + request.getSortField())));
        } else if ("desc".equals(request.getSortMethod())) {
            orders.add(Order.desc((String)("" + request.getSortField())));
        } else {
            orders.add(Order.desc((String)"id"));
        }
        List organizations = this.dataDao.list(0, request.getSize(), filters, orders);
        GatherSqlSimpleConvert convert = new GatherSqlSimpleConvert();
        ConverResourceUtils.converList((ResponseList)result, (List)organizations, (Conver)convert);
        return result;
    }

    @Override
    public GatherSimpleList listSql(GatherSqlSearchRequest request) {
        GatherSimpleList result = new GatherSimpleList();
        GatherSql bean = (GatherSql)((Object)this.dataDao.one(new Filter[]{Filter.eq((String)"tenant.id", (Object)request.getTenant()), Filter.eq((String)"key", (Object)request.getKey())}));
        if (bean == null) {
            result.setCode(1000);
            result.setMsg("\u65e0\u6548id");
            return result;
        }
        if (StringUtils.isEmpty((Object)bean.getNote())) {
            result.setCode(501);
            result.setMsg("\u65e0\u6548Sql");
            return result;
        }
        List<SimpleItem> items = this.sqlMapper.handleListSQL(bean.getNote());
        result.setList(items);
        return result;
    }

    @Override
    public MapResponse oneSql(GatherSqlSearchRequest request) {
        MapResponse result = new MapResponse();
        GatherSql bean = (GatherSql)((Object)this.dataDao.one(new Filter[]{Filter.eq((String)"tenant.id", (Object)request.getTenant()), Filter.eq((String)"key", (Object)request.getKey())}));
        if (bean == null) {
            result.setCode(1000);
            result.setMsg("\u65e0\u6548id");
            return result;
        }
        if (StringUtils.isEmpty((Object)bean.getNote())) {
            result.setCode(501);
            result.setMsg("\u65e0\u6548Sql");
            return result;
        }
        SimpleItem items = this.sqlMapper.handleOneSQL(bean.getNote());
        if (items != null) {
            result.putAll(items);
        }
        return result;
    }

    @Override
    public GatherSqlPage search(GatherSqlSearchRequest request) {
        GatherSqlPage result = new GatherSqlPage();
        Pageable pageable = new PageableConver().conver((RequestUserTokenPageObject)request);
        pageable.getFilters().addAll(FilterUtils.getFilters((Object)((Object)request)));
        pageable.getFilters().add(Filter.eq((String)"tenant.id", (Object)request.getTenant()));
        if ("asc".equals(request.getSortMethod())) {
            pageable.getOrders().add(Order.asc((String)("" + request.getSortField())));
        } else if ("desc".equals(request.getSortMethod())) {
            pageable.getOrders().add(Order.desc((String)("" + request.getSortField())));
        } else {
            pageable.getOrders().add(Order.desc((String)"id"));
        }
        Page page = this.dataDao.page(pageable);
        GatherSqlSimpleConvert convert = new GatherSqlSimpleConvert();
        ConverResourceUtils.converPage((ResponsePage)result, (Page)page, (Conver)convert);
        return result;
    }
}

