/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.admin.upms;

import com.hccake.ballcat.admin.upms.log.LogConfiguration;
import com.hccake.ballcat.system.authentication.BallcatOAuth2TokenResponseEnhancer;
import com.hccake.ballcat.system.authentication.DefaultUserInfoCoordinatorImpl;
import com.hccake.ballcat.system.authentication.SysUserDetailsServiceImpl;
import com.hccake.ballcat.system.authentication.UserInfoCoordinator;
import com.hccake.ballcat.system.properties.SystemProperties;
import com.hccake.ballcat.system.service.SysUserService;
import org.ballcat.security.properties.SecurityProperties;
import org.ballcat.springsecurity.oauth2.server.authorization.web.authentication.OAuth2TokenResponseEnhancer;
import org.ballcat.springsecurity.oauth2.server.resource.introspection.SpringAuthorizationServerSharedStoredOpaqueTokenIntrospector;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenIntrospector;

@EnableAsync
@AutoConfiguration
@MapperScan(value={"com.hccake.ballcat.**.mapper"})
@ComponentScan(value={"com.hccake.ballcat.admin.upms", "com.hccake.ballcat.system", "com.hccake.ballcat.log", "com.hccake.ballcat.file", "com.hccake.ballcat.notify"})
@EnableConfigurationProperties(value={SystemProperties.class, SecurityProperties.class})
@Import(value={LogConfiguration.class})
public class UpmsAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={OAuth2Authorization.class})
    static class SpringOAuth2AuthorizationServerConfiguration {
        SpringOAuth2AuthorizationServerConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public OAuth2TokenResponseEnhancer oAuth2TokenResponseEnhancer() {
            return new BallcatOAuth2TokenResponseEnhancer();
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="ballcat.security.oauth2.resourceserver", name={"shared-stored-token"}, havingValue="true", matchIfMissing=true)
        public OpaqueTokenIntrospector sharedStoredOpaqueTokenIntrospector(OAuth2AuthorizationService authorizationService) {
            return new SpringAuthorizationServerSharedStoredOpaqueTokenIntrospector(authorizationService);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={SysUserService.class})
    @ConditionalOnMissingBean(value={UserDetailsService.class})
    static class UserDetailsServiceConfiguration {
        UserDetailsServiceConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public UserDetailsService userDetailsService(SysUserService sysUserService, UserInfoCoordinator userInfoCoordinator) {
            return new SysUserDetailsServiceImpl(sysUserService, userInfoCoordinator);
        }

        @Bean
        @ConditionalOnMissingBean
        public UserInfoCoordinator userInfoCoordinator() {
            return new DefaultUserInfoCoordinatorImpl();
        }
    }
}

