/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.admin.upms.log;

import com.hccake.ballcat.admin.upms.log.LoginLogHandler;
import com.hccake.ballcat.admin.upms.log.SpringAuthorizationServerLoginLogHandler;
import com.hccake.ballcat.common.log.access.handler.AccessLogHandler;
import com.hccake.ballcat.common.log.operation.handler.OperationLogHandler;
import com.hccake.ballcat.log.handler.CustomAccessLogHandler;
import com.hccake.ballcat.log.handler.CustomOperationLogHandler;
import com.hccake.ballcat.log.model.entity.AccessLog;
import com.hccake.ballcat.log.model.entity.OperationLog;
import com.hccake.ballcat.log.service.AccessLogService;
import com.hccake.ballcat.log.service.LoginLogService;
import com.hccake.ballcat.log.service.OperationLogService;
import com.hccake.ballcat.log.thread.AccessLogSaveThread;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OAuth2AuthorizationServerConfigurer;
import org.springframework.security.oauth2.server.authorization.settings.AuthorizationServerSettings;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={LoginLogService.class})
public class LogConfiguration {
    @Bean
    @ConditionalOnBean(value={AccessLogService.class})
    @ConditionalOnMissingBean(value={AccessLogHandler.class})
    public AccessLogHandler<AccessLog> customAccessLogHandler(AccessLogService accessLogService) {
        return new CustomAccessLogHandler(new AccessLogSaveThread(accessLogService));
    }

    @Bean
    @ConditionalOnBean(value={OperationLogService.class})
    @ConditionalOnMissingBean(value={OperationLogHandler.class})
    public OperationLogHandler<OperationLog> customOperationLogHandler(OperationLogService operationLogService) {
        return new CustomOperationLogHandler(operationLogService);
    }

    @ConditionalOnClass(value={OAuth2AuthorizationServerConfigurer.class})
    @ConditionalOnBean(value={LoginLogService.class})
    @ConditionalOnMissingBean(value={LoginLogHandler.class})
    @Configuration(proxyBeanMethods=false)
    static class SpringAuthorizationServerLoginLogConfiguration {
        SpringAuthorizationServerLoginLogConfiguration() {
        }

        @Bean
        public LoginLogHandler springAuthorizationServerLoginLogHandler(LoginLogService loginLogService, AuthorizationServerSettings authorizationServerSettings) {
            return new SpringAuthorizationServerLoginLogHandler(loginLogService, authorizationServerSettings);
        }
    }
}

