/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.admin.upms.log;

import com.hccake.ballcat.admin.upms.log.LoginLogHandler;
import com.hccake.ballcat.common.core.util.WebUtils;
import com.hccake.ballcat.common.log.operation.enums.LogStatusEnum;
import com.hccake.ballcat.common.security.util.SecurityUtils;
import com.hccake.ballcat.log.enums.LoginEventTypeEnum;
import com.hccake.ballcat.log.handler.LoginLogUtils;
import com.hccake.ballcat.log.model.entity.LoginLog;
import com.hccake.ballcat.log.service.LoginLogService;
import javax.servlet.http.HttpServletRequest;
import org.ballcat.springsecurity.oauth2.server.authorization.authentication.OAuth2TokenRevocationAuthenticationToken;
import org.springframework.context.event.EventListener;
import org.springframework.security.authentication.ProviderNotFoundException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.event.AbstractAuthenticationFailureEvent;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.authentication.event.LogoutSuccessEvent;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AccessTokenAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationGrantAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.settings.AuthorizationServerSettings;

public class SpringAuthorizationServerLoginLogHandler
implements LoginLogHandler {
    private final LoginLogService loginLogService;
    private final AuthorizationServerSettings authorizationServerSettings;

    @EventListener(value={AuthenticationSuccessEvent.class})
    public void onAuthenticationSuccessEvent(AuthenticationSuccessEvent event) {
        Object source = event.getSource();
        String username = null;
        String tokenEndpoint = this.authorizationServerSettings.getTokenEndpoint();
        HttpServletRequest request = WebUtils.getRequest();
        boolean isOauth2LoginRequest = request.getRequestURI().equals(tokenEndpoint);
        if (isOauth2LoginRequest && source instanceof OAuth2AccessTokenAuthenticationToken) {
            username = SecurityUtils.getAuthentication().getName();
        } else if (!isOauth2LoginRequest && source instanceof UsernamePasswordAuthenticationToken) {
            username = ((UsernamePasswordAuthenticationToken)source).getName();
        }
        if (username != null) {
            LoginLog loginLog = LoginLogUtils.prodLoginLog((String)username).setMsg("\u767b\u5f55\u6210\u529f").setStatus(Integer.valueOf(LogStatusEnum.SUCCESS.getValue())).setEventType(Integer.valueOf(LoginEventTypeEnum.LOGIN.getValue()));
            this.loginLogService.save((Object)loginLog);
        }
    }

    @EventListener(value={AbstractAuthenticationFailureEvent.class})
    public void onAuthenticationFailureEvent(AbstractAuthenticationFailureEvent event) {
        if (event.getException().getClass().isAssignableFrom(ProviderNotFoundException.class)) {
            return;
        }
        Object source = event.getSource();
        String username = null;
        String tokenEndpoint = this.authorizationServerSettings.getTokenEndpoint();
        HttpServletRequest request = WebUtils.getRequest();
        boolean isOauth2LoginRequest = request.getRequestURI().equals(tokenEndpoint);
        if (isOauth2LoginRequest && source instanceof OAuth2AuthorizationGrantAuthenticationToken) {
            username = ((OAuth2AuthorizationGrantAuthenticationToken)source).getName();
        } else if (!isOauth2LoginRequest && source instanceof UsernamePasswordAuthenticationToken) {
            username = ((UsernamePasswordAuthenticationToken)source).getName();
        }
        if (username != null) {
            LoginLog loginLog = LoginLogUtils.prodLoginLog(username).setMsg(event.getException().getMessage()).setEventType(Integer.valueOf(LoginEventTypeEnum.LOGIN.getValue())).setStatus(Integer.valueOf(LogStatusEnum.FAIL.getValue()));
            this.loginLogService.save((Object)loginLog);
        }
    }

    @EventListener(value={LogoutSuccessEvent.class})
    public void onLogoutSuccessEvent(LogoutSuccessEvent event) {
        Object source = event.getSource();
        String username = null;
        String tokenRevocationEndpoint = this.authorizationServerSettings.getTokenRevocationEndpoint();
        HttpServletRequest request = WebUtils.getRequest();
        boolean isOauth2Login = request.getRequestURI().equals(tokenRevocationEndpoint);
        if (isOauth2Login && source instanceof OAuth2TokenRevocationAuthenticationToken) {
            OAuth2Authorization authorization = ((OAuth2TokenRevocationAuthenticationToken)source).getAuthorization();
            username = authorization.getPrincipalName();
        } else if (!isOauth2Login && source instanceof UsernamePasswordAuthenticationToken) {
            username = ((UsernamePasswordAuthenticationToken)source).getName();
        }
        if (username != null) {
            LoginLog loginLog = LoginLogUtils.prodLoginLog(username).setMsg("\u767b\u51fa\u6210\u529f").setEventType(Integer.valueOf(LoginEventTypeEnum.LOGOUT.getValue()));
            this.loginLogService.save((Object)loginLog);
        }
    }

    public SpringAuthorizationServerLoginLogHandler(LoginLogService loginLogService, AuthorizationServerSettings authorizationServerSettings) {
        this.loginLogService = loginLogService;
        this.authorizationServerSettings = authorizationServerSettings;
    }
}

