/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.core.https;

import com.hccake.ballcat.common.core.constant.HttpsConstants;
import com.hccake.ballcat.common.util.ArrayUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class CompatibleSSLFactory
extends SSLSocketFactory {
    private final String[] protocols;
    private final SSLSocketFactory factory;

    public CompatibleSSLFactory(String ... protocols) throws NoSuchAlgorithmException, KeyManagementException {
        this("TLS", HttpsConstants.KEY_MANAGERS, HttpsConstants.TRUST_MANAGERS, new SecureRandom(), protocols);
    }

    public CompatibleSSLFactory(String protocol, KeyManager[] keyManagers, TrustManager[] trustManagers, SecureRandom secureRandom, String ... protocols) throws NoSuchAlgorithmException, KeyManagementException {
        this.protocols = protocols;
        SSLContext context = SSLContext.getInstance(protocol);
        context.init(keyManagers, trustManagers, secureRandom);
        this.factory = context.getSocketFactory();
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.factory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.factory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.enabledProtocols(this.factory.createSocket());
    }

    @Override
    public Socket createSocket(Socket socket, InputStream inputStream, boolean b) throws IOException {
        return this.enabledProtocols(this.factory.createSocket(socket, inputStream, b));
    }

    @Override
    public Socket createSocket(Socket socket, String s, int i, boolean b) throws IOException {
        return this.enabledProtocols(this.factory.createSocket(socket, s, i, b));
    }

    @Override
    public Socket createSocket(String s, int i) throws IOException {
        return this.enabledProtocols(this.factory.createSocket(s, i));
    }

    @Override
    public Socket createSocket(String s, int i, InetAddress inetAddress, int i1) throws IOException {
        return this.enabledProtocols(this.factory.createSocket(s, i, inetAddress, i1));
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int i) throws IOException {
        return this.enabledProtocols(this.factory.createSocket(inetAddress, i));
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int i, InetAddress inetAddress1, int i1) throws IOException {
        return this.enabledProtocols(this.factory.createSocket(inetAddress, i, inetAddress1, i1));
    }

    private Socket enabledProtocols(Socket socket) {
        if (!ArrayUtils.isEmpty((Object[])this.protocols) && socket instanceof SSLSocket) {
            ((SSLSocket)socket).setEnabledProtocols(this.protocols);
        }
        return socket;
    }
}

