/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.core.jackson;

import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.hccake.ballcat.common.core.jackson.NullArrayJsonSerializer;
import com.hccake.ballcat.common.core.jackson.NullMapJsonSerializer;
import com.hccake.ballcat.common.core.jackson.NullStringJsonSerializer;
import java.util.Collection;
import java.util.Map;

public class NullSerializerProvider
extends DefaultSerializerProvider {
    private static final long serialVersionUID = 1L;
    private final JsonSerializer<Object> nullArrayJsonSerializer = new NullArrayJsonSerializer();
    private final JsonSerializer<Object> nullMapJsonSerializer = new NullMapJsonSerializer();
    private final JsonSerializer<Object> nullStringJsonSerializer = new NullStringJsonSerializer();

    public NullSerializerProvider() {
    }

    public NullSerializerProvider(NullSerializerProvider src) {
        super((DefaultSerializerProvider)src);
    }

    protected NullSerializerProvider(SerializerProvider src, SerializationConfig config, SerializerFactory f) {
        super(src, config, f);
    }

    public DefaultSerializerProvider copy() {
        if (((Object)((Object)this)).getClass() != NullSerializerProvider.class) {
            return super.copy();
        }
        return new NullSerializerProvider(this);
    }

    public NullSerializerProvider createInstance(SerializationConfig config, SerializerFactory jsf) {
        return new NullSerializerProvider((SerializerProvider)this, config, jsf);
    }

    public JsonSerializer<Object> findNullValueSerializer(BeanProperty property) throws JsonMappingException {
        JavaType propertyType = property.getType();
        if (this.isStringType(propertyType)) {
            return this.nullStringJsonSerializer;
        }
        if (this.isArrayOrCollectionTrype(propertyType)) {
            return this.nullArrayJsonSerializer;
        }
        if (this.isMapType(propertyType)) {
            return this.nullMapJsonSerializer;
        }
        return super.findNullValueSerializer(property);
    }

    private boolean isStringType(JavaType type) {
        Class clazz = type.getRawClass();
        return String.class.isAssignableFrom(clazz);
    }

    private boolean isMapType(JavaType type) {
        Class clazz = type.getRawClass();
        return Map.class.isAssignableFrom(clazz);
    }

    private boolean isArrayOrCollectionTrype(JavaType type) {
        Class clazz = type.getRawClass();
        return clazz.isArray() || Collection.class.isAssignableFrom(clazz);
    }
}

