/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.core.lock;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class JavaReentrantLock {
    protected final ReentrantLock lock = new ReentrantLock();
    protected final Condition defaultCondition = this.lock.newCondition();

    public Condition newCondition() {
        return this.getLock().newCondition();
    }

    public void lock() {
        this.getLock().lock();
    }

    public void lockInterruptibly() throws InterruptedException {
        this.getLock().lockInterruptibly();
    }

    public void runLock(Runnable runnable) throws InterruptedException {
        ReentrantLock reentrantLock = this.getLock();
        reentrantLock.lock();
        try {
            runnable.run();
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public void runLockInterruptibly(Runnable runnable) throws InterruptedException {
        ReentrantLock reentrantLock = this.getLock();
        reentrantLock.lockInterruptibly();
        try {
            runnable.run();
        }
        finally {
            reentrantLock.unlock();
        }
    }

    public void unlock() {
        this.getLock().unlock();
    }

    public void signal() {
        this.getDefaultCondition().signal();
    }

    public void signalAll() {
        this.getDefaultCondition().signalAll();
    }

    public void await() throws InterruptedException {
        this.getDefaultCondition().await();
    }

    public boolean await(long time, TimeUnit timeUnit) throws InterruptedException {
        return this.getDefaultCondition().await(time, timeUnit);
    }

    public ReentrantLock getLock() {
        return this.lock;
    }

    public Condition getDefaultCondition() {
        return this.defaultCondition;
    }

    public static interface Runnable {
        public void run() throws InterruptedException;
    }
}

