/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.core.markdown;

import cn.hutool.core.convert.Convert;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.hccake.ballcat.common.util.json.JacksonJsonToolAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class MarkdownBuilder {
    public static final String TITLE_PREFIX = "#";
    public static final String QUOTE_PREFIX = "> ";
    public static final String CODE_PREFIX = "``` ";
    public static final String CODE_SUFFIX = "```";
    public static final String BOLD_PREFIX = "**";
    public static final String ITALIC_PREFIX = "*";
    public static final String UNORDERED_LIST_PREFIX = "- ";
    public static final String ORDER_LIST_PREFIX = ". ";
    private final List<String> content = new ArrayList<String>();
    private StringBuilder lineTextBuilder = new StringBuilder();

    public MarkdownBuilder append(Object content) {
        this.lineTextBuilder.append(this.toString(content));
        return this;
    }

    public MarkdownBuilder orderList(Object content) {
        String tmp = "";
        if (!this.content.isEmpty()) {
            tmp = this.content.get(this.content.size() - 1);
        }
        int index = 1;
        String isOrderListPattern = "^\\d\\. .*";
        if (Pattern.matches(isOrderListPattern, tmp)) {
            index = Convert.toInt((Object)tmp.substring(0, tmp.indexOf(ORDER_LIST_PREFIX) - 1));
        }
        return this.orderList(index, content);
    }

    public MarkdownBuilder orderList(int index, Object content) {
        this.lineBreak();
        this.lineTextBuilder.append(index).append(ORDER_LIST_PREFIX).append(this.toString(content));
        return this;
    }

    public MarkdownBuilder unorderedList(Object content) {
        this.lineBreak();
        this.lineTextBuilder.append(UNORDERED_LIST_PREFIX).append(this.toString(content));
        return this;
    }

    public MarkdownBuilder pic(String url) {
        return this.pic("", url);
    }

    public MarkdownBuilder pic(Object title, String url) {
        this.lineTextBuilder.append("![").append(title).append("](").append(url).append(")");
        return this;
    }

    public MarkdownBuilder link(Object title, String url) {
        this.lineTextBuilder.append("[").append(title).append("](").append(url).append(")");
        return this;
    }

    public MarkdownBuilder italic(Object content) {
        this.lineTextBuilder.append(ITALIC_PREFIX).append(this.toString(content)).append(ITALIC_PREFIX);
        return this;
    }

    public MarkdownBuilder bold(Object content) {
        this.lineTextBuilder.append(BOLD_PREFIX).append(this.toString(content)).append(BOLD_PREFIX);
        return this;
    }

    public MarkdownBuilder quote(Object ... content) {
        this.lineBreak();
        this.lineTextBuilder.append(QUOTE_PREFIX);
        for (Object o : content) {
            this.lineTextBuilder.append(this.toString(o));
        }
        return this;
    }

    public MarkdownBuilder quoteBreak(Object ... content) {
        this.quote(content);
        return this.quote(new Object[0]);
    }

    public MarkdownBuilder code(String type, Object ... code) {
        this.lineBreak();
        this.lineTextBuilder.append(CODE_PREFIX).append(type);
        this.lineBreak();
        for (Object o : code) {
            this.lineTextBuilder.append(this.toString(o));
        }
        this.lineBreak();
        this.lineTextBuilder.append(CODE_SUFFIX);
        return this.lineBreak();
    }

    public MarkdownBuilder json(Object obj) {
        String json = obj instanceof String ? (String)obj : this.multiJson(obj);
        return this.code("json", json);
    }

    private String multiJson(Object obj) {
        ObjectMapper mapper = JacksonJsonToolAdapter.getMapper().copy().enable(SerializationFeature.INDENT_OUTPUT);
        return mapper.writeValueAsString(obj);
    }

    public MarkdownBuilder forceLineBreak() {
        this.content.add(this.lineTextBuilder.toString());
        this.lineTextBuilder = new StringBuilder();
        return this;
    }

    public MarkdownBuilder lineBreak() {
        if (this.lineTextBuilder.length() != 0) {
            return this.forceLineBreak();
        }
        return this;
    }

    private MarkdownBuilder title(int i, Object content) {
        this.lineBreak();
        for (int j = 0; j < i; ++j) {
            this.lineTextBuilder.append(TITLE_PREFIX);
        }
        this.content.add(this.lineTextBuilder.append(" ").append(this.toString(content)).toString());
        this.lineTextBuilder = new StringBuilder();
        return this;
    }

    public MarkdownBuilder title1(Object text) {
        return this.title(1, text);
    }

    public MarkdownBuilder title2(Object text) {
        return this.title(2, text);
    }

    public MarkdownBuilder title3(Object text) {
        return this.title(3, text);
    }

    public MarkdownBuilder title4(Object text) {
        return this.title(4, text);
    }

    public MarkdownBuilder title5(Object text) {
        return this.title(5, text);
    }

    String toString(Object o) {
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    public String toString() {
        return this.build();
    }

    public String build() {
        this.lineBreak();
        StringBuilder res = new StringBuilder();
        this.content.forEach(line -> res.append((String)line).append(" \n"));
        return res.toString();
    }
}

