/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.core.request.wrapper;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StreamUtils;

public class RepeatBodyRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger log = LoggerFactory.getLogger(RepeatBodyRequestWrapper.class);
    private final byte[] body;
    private final Map<String, String[]> parameterMap = super.getParameterMap();

    public RepeatBodyRequestWrapper(HttpServletRequest request) {
        super(request);
        this.body = RepeatBodyRequestWrapper.getByteBody(request);
    }

    public BufferedReader getReader() {
        return ObjectUtils.isEmpty((Object)this.body) ? null : new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public ServletInputStream getInputStream() {
        final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.body);
        return new ServletInputStream(){

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }

            public int read() {
                return byteArrayInputStream.read();
            }
        };
    }

    private static byte[] getByteBody(HttpServletRequest request) {
        byte[] body = new byte[]{};
        try {
            body = StreamUtils.copyToByteArray((InputStream)request.getInputStream());
        }
        catch (IOException e) {
            log.error("\u89e3\u6790\u6d41\u4e2d\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        return body;
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameterMap;
    }
}

