/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.core.spring.compose;

import com.hccake.ballcat.common.core.compose.ContextComponent;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.stereotype.Component;

@Component
public class SpringContextClosed
implements ApplicationListener<ContextClosedEvent> {
    private static final Logger log = LoggerFactory.getLogger(SpringContextClosed.class);

    public void onApplicationEvent(ContextClosedEvent event) {
        log.debug("spring context closed");
        ApplicationContext applicationContext = event.getApplicationContext();
        SpringContextClosed.contextComponentStop(applicationContext);
    }

    private static void contextComponentStop(ApplicationContext applicationContext) {
        Map contextComponentMap = applicationContext.getBeansOfType(ContextComponent.class);
        for (Map.Entry entry : contextComponentMap.entrySet()) {
            ((ContextComponent)entry.getValue()).onApplicationStop();
        }
    }
}

