/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.core.thread;

import com.hccake.ballcat.common.core.thread.AbstractQueueThread;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBlockingQueueThread<T>
extends AbstractQueueThread<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractBlockingQueueThread.class);
    private final BlockingQueue<T> queue = new LinkedBlockingQueue<T>();

    @Override
    public void put(T t) {
        if (t != null) {
            try {
                this.queue.put(t);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                log.error("{} put Object error, param: {}", new Object[]{this.getClass().toString(), t, e});
            }
        }
    }

    @Override
    protected T poll(long time) throws InterruptedException {
        return this.queue.poll(time, TimeUnit.MILLISECONDS);
    }
}

