/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.core.thread;

import com.hccake.ballcat.common.core.lock.JavaReentrantLock;
import com.hccake.ballcat.common.core.thread.AbstractThreadContextComponent;
import java.util.Comparator;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDynamicTimer<T>
extends AbstractThreadContextComponent {
    private static final Logger log = LoggerFactory.getLogger(AbstractDynamicTimer.class);
    private final JavaReentrantLock lock = new JavaReentrantLock();
    protected final PriorityBlockingQueue<T> queue = new PriorityBlockingQueue<T>(this.defaultCapacity(), this.comparator());

    public abstract Comparator<T> comparator();

    protected int defaultCapacity() {
        return 11;
    }

    protected abstract long sleepTime(T var1);

    public void put(T t) {
        if (t == null) {
            return;
        }
        try {
            this.lock.runLockInterruptibly(() -> {
                this.queue.add(t);
                this.lock.signalAll();
            });
        }
        catch (InterruptedException e) {
            this.interrupt();
        }
        catch (Exception e) {
            log.error("{} put error, param: {}", new Object[]{this.getClass().toString(), t, e});
        }
    }

    @Override
    public void run() {
        this.init();
        while (this.isRun()) {
            try {
                T t = this.pool();
                this.lock.runLockInterruptibly(() -> {
                    if (t == null) {
                        this.lock.await(24L, TimeUnit.HOURS);
                        return;
                    }
                    long sleepTime = this.sleepTime(t);
                    if (sleepTime > 0L && this.lock.await(sleepTime, TimeUnit.MILLISECONDS)) {
                        this.put(t);
                        return;
                    }
                    this.process(t);
                });
            }
            catch (InterruptedException e) {
                this.interrupt();
                this.shutdown();
            }
            catch (Exception e) {
                log.error("\u7c7b: {}; \u7ebf\u7a0b: {}; \u8fd0\u884c\u5f02\u5e38! ", new Object[]{this.getSimpleName(), this.getId(), e});
            }
        }
    }

    protected T pool() {
        return this.queue.poll();
    }

    protected abstract void process(T var1);

    protected void shutdown() {
        log.warn("\u7c7b: {}; \u7ebf\u7a0b: {}; \u88ab\u4e2d\u65ad! \u5269\u4f59\u6570\u636e: {}", new Object[]{this.getSimpleName(), this.getId(), this.queue.size()});
    }
}

