/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.core.thread;

import com.hccake.ballcat.common.core.compose.ContextComponent;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public abstract class AbstractQueueThread<E>
extends Thread
implements ContextComponent {
    private static final Logger log = LoggerFactory.getLogger(AbstractQueueThread.class);
    private static final int DEFAULT_BATCH_SIZE = 500;
    private static final long DEFAULT_BATCH_TIMEOUT_MS = 30000L;
    private static final long POLL_TIMEOUT_MS = 5000L;

    public int getBatchSize() {
        return 500;
    }

    public long getBatchTimeout() {
        return 30000L;
    }

    public long getPollTimeout() {
        return 5000L;
    }

    public abstract void put(E var1);

    protected void init() {
    }

    public boolean isRun() {
        return !this.isInterrupted();
    }

    protected void preProcess() {
    }

    protected abstract E poll(long var1) throws InterruptedException;

    protected void receiveProcess(List<E> list, E e) {
        list.add(e);
    }

    protected abstract void process(List<E> var1) throws Exception;

    @Override
    public void run() {
        this.init();
        while (this.isRun()) {
            ArrayList list = new ArrayList(this.getBatchSize());
            try {
                this.preProcess();
                this.fillList(list);
                if (!this.isRun()) {
                    this.shutdown(list);
                    continue;
                }
                this.process(list);
            }
            catch (InterruptedException e) {
                this.shutdown(list);
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                this.error(e, list);
            }
            catch (Throwable t) {
                log.error("\u7ebf\u7a0b\u961f\u5217\u8fd0\u884c\u5f02\u5e38!", t);
                throw t;
            }
        }
    }

    protected void fillList(List<E> list) {
        long timestamp = 0L;
        int count = 0;
        while (count < this.getBatchSize()) {
            boolean isBreak;
            E e = this.poll();
            if (e != null) {
                if (count++ == 0) {
                    timestamp = System.currentTimeMillis();
                }
                this.receiveProcess(list, e);
            }
            if (!(isBreak = !this.isRun() || !CollectionUtils.isEmpty(list) && System.currentTimeMillis() - timestamp >= this.getBatchTimeout())) continue;
            break;
        }
    }

    public E poll() {
        E e = null;
        try {
            e = this.poll(this.getPollTimeout());
        }
        catch (InterruptedException ex) {
            log.error("{} \u7c7b\u7684poll\u7ebf\u7a0b\u88ab\u4e2d\u65ad!id: {}", (Object)this.getClass().getSimpleName(), (Object)this.getId());
            this.interrupt();
        }
        return e;
    }

    protected abstract void error(Throwable var1, List<E> var2);

    protected void shutdown(List<E> list) {
        log.warn("{} \u7ebf\u7a0b: {} \u88ab\u5173\u95ed. \u6570\u636e:{}", new Object[]{this.getClass().getSimpleName(), this.getId(), list});
    }

    @Override
    public void onApplicationStart() {
        this.setName(this.getClass().getSimpleName());
        if (!this.isAlive()) {
            this.start();
        }
    }

    @Override
    public void onApplicationStop() {
        log.warn("{} \u7ebf\u7a0b: {}; \u5f00\u59cb\u5173\u95ed!", (Object)this.getClass().getSimpleName(), (Object)this.getId());
        this.interrupt();
    }
}

