/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.core.thread;

import com.hccake.ballcat.common.core.compose.ContextComponent;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTimer
extends Thread
implements ContextComponent {
    private static final Logger log = LoggerFactory.getLogger(AbstractTimer.class);

    public long getTimeout() {
        return TimeUnit.SECONDS.toMillis(30L);
    }

    public boolean isRun() {
        return !this.isInterrupted();
    }

    protected void init() {
    }

    protected abstract void process();

    protected void shutdown() {
    }

    protected void error(Exception e) {
        log.error("{} \u7c7b \u7ebf\u7a0b: {} \u51fa\u73b0\u5f02\u5e38!", new Object[]{this.getClass().getSimpleName(), this.getId(), e});
    }

    @Override
    public void run() {
        this.init();
        while (this.isRun()) {
            try {
                this.process();
                if (!this.isRun()) {
                    this.shutdown();
                    return;
                }
                Thread.sleep(this.getTimeout());
            }
            catch (InterruptedException e) {
                this.interrupt();
                this.shutdown();
            }
            catch (Exception e) {
                this.error(e);
            }
        }
    }

    @Override
    public void onApplicationStart() {
        this.setName(this.getClass().getSimpleName());
        if (!this.isAlive()) {
            this.start();
        }
    }

    @Override
    public void onApplicationStop() {
        log.warn("{} \u7ebf\u7a0b: {}; \u5f00\u59cb\u5173\u95ed!", (Object)this.getClass().getSimpleName(), (Object)this.getId());
        this.interrupt();
    }
}

