/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.core.validation.validator;

import com.hccake.ballcat.common.core.validation.constraints.ValueOfEnum;
import javax.validation.ConstraintDefinitionException;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueOfEnumValidator
implements ConstraintValidator<ValueOfEnum, Object> {
    private static final Logger log = LoggerFactory.getLogger(ValueOfEnumValidator.class);
    private Class<?>[] targetEnum;
    private String checkMethod;
    private boolean allowNull;

    public void initialize(ValueOfEnum constraintAnnotation) {
        this.targetEnum = constraintAnnotation.enumClass();
        this.checkMethod = constraintAnnotation.method();
        this.allowNull = constraintAnnotation.allowNull();
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        if (value == null) {
            return this.allowNull;
        }
        int n = 0;
        Class<?>[] classArray = this.targetEnum;
        int n2 = classArray.length;
        if (n < n2) {
            Class<?> eClass = classArray[n];
            Class clazz = ClassUtils.isPrimitiveWrapper(value.getClass()) ? ClassUtils.wrapperToPrimitive(value.getClass()) : value.getClass();
            try {
                Object enumInstance = MethodUtils.invokeStaticMethod(eClass, (String)this.checkMethod, (Object[])new Object[]{value}, (Class[])new Class[]{clazz});
                return enumInstance != null;
            }
            catch (NoSuchMethodException ex) {
                throw new ConstraintDefinitionException((Throwable)ex);
            }
            catch (Exception ex) {
                log.warn("check enum error: ", (Throwable)ex);
                return false;
            }
        }
        return false;
    }
}

