/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.desensitize;

import cn.hutool.core.lang.Assert;
import com.hccake.ballcat.common.desensitize.DesensitizationHandlerHolder;
import com.hccake.ballcat.common.desensitize.enums.RegexDesensitizationTypeEnum;
import com.hccake.ballcat.common.desensitize.enums.SlideDesensitizationTypeEnum;
import com.hccake.ballcat.common.desensitize.functions.DesensitizeFunction;
import com.hccake.ballcat.common.desensitize.handler.RegexDesensitizationHandler;
import com.hccake.ballcat.common.desensitize.handler.SimpleDesensitizationHandler;
import com.hccake.ballcat.common.desensitize.handler.SlideDesensitizationHandler;
import com.hccake.ballcat.common.desensitize.json.annotation.JsonRegexDesensitize;
import com.hccake.ballcat.common.desensitize.json.annotation.JsonSimpleDesensitize;
import com.hccake.ballcat.common.desensitize.json.annotation.JsonSlideDesensitize;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class AnnotationHandlerHolder {
    private static final AnnotationHandlerHolder INSTANCE = new AnnotationHandlerHolder();
    private final Map<Class<? extends Annotation>, DesensitizeFunction> annotationHandlers = new ConcurrentHashMap<Class<? extends Annotation>, DesensitizeFunction>();

    private AnnotationHandlerHolder() {
        this.annotationHandlers.put(JsonSimpleDesensitize.class, (annotation, value) -> {
            JsonSimpleDesensitize an = (JsonSimpleDesensitize)annotation;
            Class<? extends SimpleDesensitizationHandler> handlerClass = an.handler();
            SimpleDesensitizationHandler desensitizationHandler = DesensitizationHandlerHolder.getSimpleHandler(handlerClass);
            Assert.notNull((Object)desensitizationHandler, (String)"SimpleDesensitizationHandler can not be Null", (Object[])new Object[0]);
            return desensitizationHandler.handle(value);
        });
        this.annotationHandlers.put(JsonRegexDesensitize.class, (annotation, value) -> {
            JsonRegexDesensitize an = (JsonRegexDesensitize)annotation;
            RegexDesensitizationTypeEnum type = an.type();
            RegexDesensitizationHandler regexDesensitizationHandler = DesensitizationHandlerHolder.getRegexDesensitizationHandler();
            return RegexDesensitizationTypeEnum.CUSTOM.equals((Object)type) ? regexDesensitizationHandler.handle(value, an.regex(), an.replacement()) : regexDesensitizationHandler.handle(value, type);
        });
        this.annotationHandlers.put(JsonSlideDesensitize.class, (annotation, value) -> {
            JsonSlideDesensitize an = (JsonSlideDesensitize)annotation;
            SlideDesensitizationTypeEnum type = an.type();
            SlideDesensitizationHandler slideDesensitizationHandler = DesensitizationHandlerHolder.getSlideDesensitizationHandler();
            return SlideDesensitizationTypeEnum.CUSTOM.equals((Object)type) ? slideDesensitizationHandler.handle(value, an.leftPlainTextLen(), an.rightPlainTextLen(), an.maskString()) : slideDesensitizationHandler.handle(value, type);
        });
    }

    public static DesensitizeFunction getHandleFunction(Class<? extends Annotation> annotationType) {
        return AnnotationHandlerHolder.INSTANCE.annotationHandlers.get(annotationType);
    }

    public static DesensitizeFunction addHandleFunction(Class<? extends Annotation> annotationType, DesensitizeFunction desensitizeFunction) {
        Assert.notNull(annotationType, (String)"annotation cannot be null", (Object[])new Object[0]);
        Assert.notNull((Object)desensitizeFunction, (String)"desensitization function cannot be null", (Object[])new Object[0]);
        return AnnotationHandlerHolder.INSTANCE.annotationHandlers.put(annotationType, desensitizeFunction);
    }

    public static Set<Class<? extends Annotation>> getAnnotationClasses() {
        return AnnotationHandlerHolder.INSTANCE.annotationHandlers.keySet();
    }
}

