/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.desensitize;

import com.hccake.ballcat.common.desensitize.handler.DesensitizationHandler;
import com.hccake.ballcat.common.desensitize.handler.RegexDesensitizationHandler;
import com.hccake.ballcat.common.desensitize.handler.SimpleDesensitizationHandler;
import com.hccake.ballcat.common.desensitize.handler.SlideDesensitizationHandler;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;

public final class DesensitizationHandlerHolder {
    private static final DesensitizationHandlerHolder INSTANCE = new DesensitizationHandlerHolder();
    private final Map<Class<? extends DesensitizationHandler>, DesensitizationHandler> desensitizationHandlerMap = new ConcurrentHashMap<Class<? extends DesensitizationHandler>, DesensitizationHandler>(16);

    private DesensitizationHandlerHolder() {
        this.desensitizationHandlerMap.put(SlideDesensitizationHandler.class, new SlideDesensitizationHandler());
        this.desensitizationHandlerMap.put(RegexDesensitizationHandler.class, new RegexDesensitizationHandler());
        ServiceLoader<SimpleDesensitizationHandler> loadedDrivers = ServiceLoader.load(SimpleDesensitizationHandler.class);
        for (SimpleDesensitizationHandler desensitizationHandler : loadedDrivers) {
            this.desensitizationHandlerMap.put(desensitizationHandler.getClass(), desensitizationHandler);
        }
    }

    public static DesensitizationHandler getHandler(Class<? extends DesensitizationHandler> handlerClass) {
        return DesensitizationHandlerHolder.INSTANCE.desensitizationHandlerMap.get(handlerClass);
    }

    public static RegexDesensitizationHandler getRegexDesensitizationHandler() {
        return (RegexDesensitizationHandler)DesensitizationHandlerHolder.INSTANCE.desensitizationHandlerMap.get(RegexDesensitizationHandler.class);
    }

    public static SlideDesensitizationHandler getSlideDesensitizationHandler() {
        return (SlideDesensitizationHandler)DesensitizationHandlerHolder.INSTANCE.desensitizationHandlerMap.get(SlideDesensitizationHandler.class);
    }

    public static SimpleDesensitizationHandler getSimpleHandler(Class<? extends SimpleDesensitizationHandler> handlerClass) {
        return (SimpleDesensitizationHandler)DesensitizationHandlerHolder.INSTANCE.desensitizationHandlerMap.get(handlerClass);
    }

    public static DesensitizationHandler addHandler(Class<? extends DesensitizationHandler> handlerClass, DesensitizationHandler handler) {
        return DesensitizationHandlerHolder.INSTANCE.desensitizationHandlerMap.put(handlerClass, handler);
    }
}

