/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.desensitize.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.hccake.ballcat.common.desensitize.AnnotationHandlerHolder;
import com.hccake.ballcat.common.desensitize.functions.DesensitizeFunction;
import com.hccake.ballcat.common.desensitize.json.DesensitizeStrategy;
import java.io.IOException;
import java.lang.annotation.Annotation;

public class JsonDesensitizeSerializer
extends JsonSerializer<Object> {
    private final Annotation jsonDesensitizeAnnotation;
    private final DesensitizeStrategy desensitizeStrategy;

    public JsonDesensitizeSerializer(Annotation jsonDesensitizeAnnotation, DesensitizeStrategy desensitizeStrategy) {
        this.jsonDesensitizeAnnotation = jsonDesensitizeAnnotation;
        this.desensitizeStrategy = desensitizeStrategy;
    }

    public void serialize(Object value, JsonGenerator jsonGenerator, SerializerProvider serializers) throws IOException {
        if (value instanceof String) {
            String str = (String)value;
            String fieldName = jsonGenerator.getOutputContext().getCurrentName();
            if (this.desensitizeStrategy != null && this.desensitizeStrategy.ignoreField(fieldName)) {
                jsonGenerator.writeString(str);
                return;
            }
            DesensitizeFunction handleFunction = AnnotationHandlerHolder.getHandleFunction(this.jsonDesensitizeAnnotation.annotationType());
            if (handleFunction == null) {
                jsonGenerator.writeString(str);
                return;
            }
            jsonGenerator.writeString(handleFunction.desensitize(this.jsonDesensitizeAnnotation, str));
        }
    }
}

