/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.desensitize.json;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.hccake.ballcat.common.desensitize.AnnotationHandlerHolder;
import com.hccake.ballcat.common.desensitize.json.DesensitizeStrategy;
import com.hccake.ballcat.common.desensitize.json.JsonDesensitizeSerializer;
import java.lang.annotation.Annotation;
import java.util.List;

public class JsonDesensitizeSerializerModifier
extends BeanSerializerModifier {
    private DesensitizeStrategy desensitizeStrategy;

    public JsonDesensitizeSerializerModifier() {
    }

    public JsonDesensitizeSerializerModifier(DesensitizeStrategy desensitizeStrategy) {
        this.desensitizeStrategy = desensitizeStrategy;
    }

    public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
        for (BeanPropertyWriter beanProperty : beanProperties) {
            Annotation annotation = this.getDesensitizeAnnotation(beanProperty);
            if (annotation == null || !beanProperty.getType().isTypeOrSubTypeOf(String.class)) continue;
            beanProperty.assignSerializer((JsonSerializer)new JsonDesensitizeSerializer(annotation, this.desensitizeStrategy));
        }
        return beanProperties;
    }

    private Annotation getDesensitizeAnnotation(BeanPropertyWriter beanProperty) {
        for (Class<? extends Annotation> annotationClass : AnnotationHandlerHolder.getAnnotationClasses()) {
            Annotation annotation = beanProperty.getAnnotation(annotationClass);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }
}

