/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.log.access.filter;

import com.hccake.ballcat.common.core.request.wrapper.RepeatBodyRequestWrapper;
import com.hccake.ballcat.common.log.access.handler.AccessLogHandler;
import com.hccake.ballcat.common.log.util.LogUtils;
import java.io.IOException;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.MDC;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.ContentCachingResponseWrapper;
import org.springframework.web.util.UrlPathHelper;

public class AccessLogFilter
extends OncePerRequestFilter {
    private final AccessLogHandler<?> accessLogService;
    private final List<String> ignoreUrlPatterns;
    private static final AntPathMatcher ANT_PATH_MATCHER = new AntPathMatcher();
    private static final UrlPathHelper URL_PATH_HELPER = new UrlPathHelper();

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String lookupPathForRequest = URL_PATH_HELPER.getLookupPathForRequest(request);
        for (String ignoreUrlPattern : this.ignoreUrlPatterns) {
            if (!ANT_PATH_MATCHER.match(ignoreUrlPattern, lookupPathForRequest)) continue;
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        Object requestWrapper = LogUtils.isMultipartContent(request) ? request : new RepeatBodyRequestWrapper(request);
        ContentCachingResponseWrapper responseWrapper = new ContentCachingResponseWrapper(response);
        Long startTime = System.currentTimeMillis();
        Throwable myThrowable = null;
        String traceId = MDC.get((String)"traceId");
        try {
            filterChain.doFilter((ServletRequest)requestWrapper, (ServletResponse)responseWrapper);
        }
        catch (Throwable throwable) {
            myThrowable = throwable;
            throw throwable;
        }
        finally {
            if (StringUtils.isBlank((CharSequence)MDC.get((String)"traceId"))) {
                MDC.put((String)"traceId", (String)traceId);
            }
            Long endTime = System.currentTimeMillis();
            Long executionTime = endTime - startTime;
            Throwable throwable = (Throwable)requestWrapper.getAttribute("javax.servlet.error.exception");
            if (throwable != null) {
                myThrowable = throwable;
            }
            try {
                this.accessLogService.handleLog((HttpServletRequest)requestWrapper, (HttpServletResponse)responseWrapper, executionTime, myThrowable);
            }
            catch (Exception e) {
                this.logger.error((Object)"logging access_log error!", (Throwable)e);
            }
            responseWrapper.copyBodyToResponse();
        }
    }

    public AccessLogFilter(AccessLogHandler<?> accessLogService, List<String> ignoreUrlPatterns) {
        this.accessLogService = accessLogService;
        this.ignoreUrlPatterns = ignoreUrlPatterns;
    }
}

