/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.log.operation.aspect;

import com.hccake.ballcat.common.log.operation.annotation.OperationLogging;
import com.hccake.ballcat.common.log.operation.handler.OperationLogHandler;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.Assert;

@Aspect
public class OperationLogAspect<T> {
    private static final Logger log = LoggerFactory.getLogger(OperationLogAspect.class);
    private final OperationLogHandler<T> operationLogHandler;

    @Around(value="execution(@(@com.hccake.ballcat.common.log.operation.annotation.OperationLogging *) * *(..)) || @annotation(com.hccake.ballcat.common.log.operation.annotation.OperationLogging)")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        long startTime = System.currentTimeMillis();
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        OperationLogging operationLogging = (OperationLogging)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, OperationLogging.class);
        Assert.notNull((Object)operationLogging, (String)"operationLogging annotation must not be null!");
        T operationLog = this.operationLogHandler.buildLog(operationLogging, joinPoint);
        Throwable throwable = null;
        Object result = null;
        try {
            Object object = result = joinPoint.proceed();
            return object;
        }
        catch (Throwable e) {
            throwable = e;
            throw e;
        }
        finally {
            boolean isSaveResult = operationLogging.recordResult();
            this.handleLog(joinPoint, startTime, operationLog, throwable, isSaveResult, result);
        }
    }

    private void handleLog(ProceedingJoinPoint joinPoint, long startTime, T operationLog, Throwable throwable, boolean isSaveResult, Object result) {
        try {
            long executionTime = System.currentTimeMillis() - startTime;
            this.operationLogHandler.recordExecutionInfo(operationLog, joinPoint, executionTime, throwable, isSaveResult, result);
            this.operationLogHandler.handleLog(operationLog);
        }
        catch (Exception e) {
            log.error("\u8bb0\u5f55\u64cd\u4f5c\u65e5\u5fd7\u5f02\u5e38\uff1a{}", operationLog);
        }
    }

    public OperationLogAspect(OperationLogHandler<T> operationLogHandler) {
        this.operationLogHandler = operationLogHandler;
    }
}

