/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.log.util;

import java.io.BufferedReader;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.web.util.ContentCachingResponseWrapper;

public final class LogUtils {
    private static final Logger log = LoggerFactory.getLogger(LogUtils.class);

    public static String getRequestBody(HttpServletRequest request) {
        String body = null;
        if (!request.getMethod().equals(HttpMethod.GET.name())) {
            try {
                BufferedReader reader = request.getReader();
                if (reader != null) {
                    body = reader.lines().collect(Collectors.joining(System.lineSeparator()));
                }
            }
            catch (Exception e) {
                log.error("\u8bfb\u53d6\u8bf7\u6c42\u4f53\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
        return body;
    }

    public static String getResponseBody(HttpServletRequest request, HttpServletResponse response) {
        try {
            if (response instanceof ContentCachingResponseWrapper) {
                ContentCachingResponseWrapper responseWrapper = (ContentCachingResponseWrapper)response;
                byte[] contentAsByteArray = responseWrapper.getContentAsByteArray();
                return new String(contentAsByteArray, StandardCharsets.UTF_8);
            }
            log.warn("\u5bf9\u4e8e\u672a\u5305\u88c5\u7684\u54cd\u5e94\u4f53\uff0c\u9ed8\u8ba4\u4e0d\u8fdb\u884c\u8bfb\u53d6\u8bf7\u6c42\u4f53\uff0c\u8bf7\u6c42 uri: [{}]", (Object)request.getRequestURI());
        }
        catch (Exception exception) {
            log.error("\u83b7\u53d6\u54cd\u5e94\u4f53\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u6c42 uri: [{}]", (Object)request.getRequestURI());
        }
        return "";
    }

    public static boolean isMultipartContent(HttpServletRequest request) {
        String contentType = request.getContentType();
        return contentType != null && contentType.toLowerCase().startsWith("multipart/");
    }

    private LogUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

