/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.model.result;

import com.hccake.ballcat.common.i18n.I18nClass;
import com.hccake.ballcat.common.model.result.ResultCode;
import com.hccake.ballcat.common.model.result.SystemResultCode;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;

@I18nClass
@Schema(title="\u8fd4\u56de\u4f53\u7ed3\u6784")
public class R<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Schema(title="\u8fd4\u56de\u72b6\u6001\u7801", defaultValue="0")
    private int code;
    @Schema(title="\u8fd4\u56de\u4fe1\u606f", defaultValue="Success")
    private String message;
    @Schema(title="\u6570\u636e", nullable=true, defaultValue="null")
    private T data;

    public static <T> R<T> ok() {
        return R.ok(null);
    }

    public static <T> R<T> ok(T data) {
        return R.ok(data, SystemResultCode.SUCCESS.getMessage());
    }

    public static <T> R<T> ok(T data, String message) {
        return new R<T>().setCode(SystemResultCode.SUCCESS.getCode()).setData(data).setMessage(message);
    }

    public static <T> R<T> failed(int code, String message) {
        return new R<T>().setCode(code).setMessage(message);
    }

    public static <T> R<T> failed(ResultCode failMsg) {
        return R.failed(failMsg.getCode(), failMsg.getMessage());
    }

    public static <T> R<T> failed(ResultCode failMsg, String message) {
        return R.failed(failMsg.getCode(), message);
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public T getData() {
        return this.data;
    }

    public R<T> setCode(int code) {
        this.code = code;
        return this;
    }

    public R<T> setMessage(String message) {
        this.message = message;
        return this;
    }

    public R<T> setData(T data) {
        this.data = data;
        return this;
    }

    public String toString() {
        return "R(code=" + this.getCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ")";
    }

    public R() {
    }

    public R(int code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }
}

