/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.redis;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.RedisStreamCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.Record;
import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.connection.stream.StreamReadOptions;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.SessionCallback;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.StreamOperations;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.lang.Nullable;

public class RedisHelper {
    private static final Logger log = LoggerFactory.getLogger(RedisHelper.class);
    public static final RedisHelper INSTANCE = new RedisHelper();
    private static final DefaultRedisScript<Long> INCR_BY_EXPIRE_LUA_SCRIPT = new DefaultRedisScript("local r = redis.call('INCRBY', KEYS[1], ARGV[1]) redis.call('EXPIRE', KEYS[1], ARGV[2]) return r", Long.class);
    static RedisTemplate<String, String> redisTemplate;

    private RedisHelper() {
    }

    public static RedisTemplate<String, String> getRedisTemplate() {
        return redisTemplate;
    }

    public static void setRedisTemplate(RedisTemplate<String, String> redisTemplate) {
        RedisHelper.redisTemplate = redisTemplate;
    }

    private static RedisSerializer<String> getKeySerializer() {
        return redisTemplate.getKeySerializer();
    }

    private static RedisSerializer<String> getValueSerializer() {
        return redisTemplate.getValueSerializer();
    }

    public static HashOperations<String, String, String> hashOps() {
        return redisTemplate.opsForHash();
    }

    public static ValueOperations<String, String> valueOps() {
        return redisTemplate.opsForValue();
    }

    public static ListOperations<String, String> listOps() {
        return redisTemplate.opsForList();
    }

    public static SetOperations<String, String> setOps() {
        return redisTemplate.opsForSet();
    }

    public static ZSetOperations<String, String> zSetOps() {
        return redisTemplate.opsForZSet();
    }

    public static StreamOperations<String, String, String> streamOps() {
        return redisTemplate.opsForStream();
    }

    @Deprecated
    public static boolean hasKey(String key) {
        Boolean b = redisTemplate.hasKey((Object)key);
        return b != null && b != false;
    }

    @Deprecated
    public static boolean delete(String key) {
        Boolean b = redisTemplate.delete((Object)key);
        return b != null && b != false;
    }

    @Deprecated
    public static long delete(Collection<String> keys) {
        Long l = redisTemplate.delete(keys);
        return l == null ? 0L : l;
    }

    public static boolean del(String key) {
        return Boolean.TRUE.equals(redisTemplate.delete((Object)key));
    }

    public static long del(String ... keys) {
        return RedisHelper.del(Arrays.asList(keys));
    }

    public static long del(Collection<String> keys) {
        Long deleteNumber = redisTemplate.delete(keys);
        return deleteNumber == null ? 0L : deleteNumber;
    }

    public static boolean exists(String key) {
        return Boolean.TRUE.equals(redisTemplate.hasKey((Object)key));
    }

    public static long exists(String ... keys) {
        return RedisHelper.exists(Arrays.asList(keys));
    }

    public static long exists(Collection<String> keys) {
        Long number = redisTemplate.countExistingKeys(keys);
        return number == null ? 0L : number;
    }

    public static boolean expire(String key, long timeout) {
        return RedisHelper.expire(key, timeout, TimeUnit.SECONDS);
    }

    public static boolean expire(String key, long timeout, TimeUnit timeUnit) {
        return Boolean.TRUE.equals(redisTemplate.expire((Object)key, timeout, timeUnit));
    }

    public static boolean expireAt(String key, Date date) {
        return Boolean.TRUE.equals(redisTemplate.expireAt((Object)key, date));
    }

    public static boolean expireAt(String key, Instant expireAt) {
        return Boolean.TRUE.equals(redisTemplate.expireAt((Object)key, expireAt));
    }

    public static Set<String> keys(String pattern) {
        return redisTemplate.keys((Object)pattern);
    }

    public static long ttl(String key) {
        return redisTemplate.getExpire((Object)key);
    }

    public static Cursor<String> scan(ScanOptions scanOptions) {
        return redisTemplate.scan(scanOptions);
    }

    public static Cursor<String> scan(String patten) {
        ScanOptions scanOptions = ScanOptions.scanOptions().match(patten).build();
        return RedisHelper.scan(scanOptions);
    }

    public static Cursor<String> scan(String patten, long count) {
        ScanOptions scanOptions = ScanOptions.scanOptions().match(patten).count(count).build();
        return RedisHelper.scan(scanOptions);
    }

    public static long decr(String key) {
        return RedisHelper.valueOps().decrement((Object)key);
    }

    public static long decrBy(String key, long delta) {
        return RedisHelper.valueOps().decrement((Object)key, delta);
    }

    public static String get(String key) {
        return (String)RedisHelper.valueOps().get((Object)key);
    }

    public static String getDel(String key) {
        return (String)RedisHelper.valueOps().getAndDelete((Object)key);
    }

    public static String getEx(String key, long timeout) {
        return RedisHelper.getEx(key, timeout, TimeUnit.SECONDS);
    }

    public static String getEx(String key, long timeout, TimeUnit timeUnit) {
        return (String)RedisHelper.valueOps().getAndExpire((Object)key, timeout, timeUnit);
    }

    public static String getSet(String key, String value) {
        return (String)RedisHelper.valueOps().getAndSet((Object)key, (Object)value);
    }

    public static long incr(String key) {
        return RedisHelper.valueOps().increment((Object)key);
    }

    public static long incrAndExpire(String key, long timeout) {
        return RedisHelper.incrByAndExpire(key, 1L, timeout);
    }

    public static long incrBy(String key, long delta) {
        return RedisHelper.valueOps().increment((Object)key, delta);
    }

    public static long incrByAndExpire(String key, long delta, long timeout) {
        return (Long)redisTemplate.execute(INCR_BY_EXPIRE_LUA_SCRIPT, Collections.singletonList(key), new Object[]{String.valueOf(delta), String.valueOf(timeout)});
    }

    public static double incrByFloat(String key, double delta) {
        return RedisHelper.valueOps().increment((Object)key, delta);
    }

    @Deprecated
    public static Long increment(String key) {
        return RedisHelper.valueOps().increment((Object)key);
    }

    @Deprecated
    public static Long increment(String key, long delta) {
        return RedisHelper.valueOps().increment((Object)key, delta);
    }

    @Deprecated
    public static Long incrementAndExpire(String key, long time) {
        return RedisHelper.incrementAndExpire(key, 1L, time);
    }

    @Deprecated
    public static Long incrementAndExpire(String key, long delta, long time) {
        Long increment = RedisHelper.valueOps().increment((Object)key, delta);
        RedisHelper.expire(key, time);
        return increment;
    }

    public static List<String> mGet(Collection<String> keys) {
        return RedisHelper.valueOps().multiGet(keys);
    }

    public static List<String> mGet(String ... keys) {
        return RedisHelper.mGet(Arrays.asList(keys));
    }

    public static Map<String, String> mGetToMap(Collection<String> keys) {
        List values = RedisHelper.valueOps().multiGet(keys);
        HashMap<String, String> map = new HashMap<String, String>(keys.size());
        if (values == null || values.isEmpty()) {
            return map;
        }
        Iterator<String> keysIterator = keys.iterator();
        Iterator valuesIterator = values.iterator();
        while (keysIterator.hasNext()) {
            String key = keysIterator.next();
            String value = (String)valuesIterator.next();
            if (value == null) continue;
            map.put(key, value);
        }
        return map;
    }

    public static Map<String, String> mGetToMap(String ... keys) {
        return RedisHelper.mGetToMap(Arrays.asList(keys));
    }

    @Deprecated
    public static List<String> multiGet(Collection<String> keys) {
        List list = RedisHelper.valueOps().multiGet(keys);
        return list == null ? new ArrayList<String>() : new ArrayList(list);
    }

    public static void set(String key, String value) {
        RedisHelper.valueOps().set((Object)key, (Object)value);
    }

    public static void set(String key, String value, long timeout) {
        RedisHelper.set(key, value, timeout, TimeUnit.SECONDS);
    }

    public static void set(String key, String value, long timeout, TimeUnit timeUnit) {
        RedisHelper.setEx(key, value, timeout, timeUnit);
    }

    @Deprecated
    public static void set(String key, String val, Instant instant) {
        RedisHelper.valueOps().set((Object)key, (Object)val);
        RedisHelper.getRedisTemplate().expireAt((Object)key, instant);
    }

    public static void setEx(String key, String value, long timeout) {
        RedisHelper.setEx(key, value, timeout, TimeUnit.SECONDS);
    }

    public static void setEx(String key, String value, long timeout, TimeUnit timeUnit) {
        RedisHelper.valueOps().set((Object)key, (Object)value, timeout, timeUnit);
    }

    public static void setExAt(String key, String value, Instant expireTime) {
        long timeout = expireTime.getEpochSecond() - Instant.now().getEpochSecond();
        RedisHelper.setEx(key, value, timeout);
    }

    public static boolean setNx(String key, String value) {
        return Boolean.TRUE.equals(RedisHelper.valueOps().setIfAbsent((Object)key, (Object)value));
    }

    @Deprecated
    public static boolean setIfAbsent(String key, String value) {
        Boolean b = RedisHelper.valueOps().setIfAbsent((Object)key, (Object)value);
        return b != null && b != false;
    }

    public static boolean setNxEx(String key, String value, long timeout) {
        return RedisHelper.setNxEx(key, value, timeout, TimeUnit.SECONDS);
    }

    public static boolean setNxEx(String key, String value, long timeout, TimeUnit timeUnit) {
        return Boolean.TRUE.equals(RedisHelper.valueOps().setIfAbsent((Object)key, (Object)value, timeout, timeUnit));
    }

    @Deprecated
    public static boolean setIfAbsent(String key, String value, long time) {
        Boolean b = RedisHelper.valueOps().setIfAbsent((Object)key, (Object)value, Duration.ofSeconds(time));
        return b != null && b != false;
    }

    public static long hDel(String key, String ... fields) {
        return RedisHelper.hashOps().delete((Object)key, (Object[])fields);
    }

    public static boolean hExists(String key, String field) {
        return RedisHelper.hashOps().hasKey((Object)key, (Object)field);
    }

    public static String hGet(String key, String field) {
        return (String)RedisHelper.hashOps().get((Object)key, (Object)field);
    }

    public static Map<String, String> hGetAll(String key) {
        return RedisHelper.hashOps().entries((Object)key);
    }

    public static long hIncrBy(String key, String field, long delta) {
        return RedisHelper.hashOps().increment((Object)key, (Object)field, delta);
    }

    public static Long hIncrBy(String key, String field) {
        return RedisHelper.hIncrBy(key, field, 1L);
    }

    public static double hIncrByFloat(String key, String field, double delta) {
        return RedisHelper.hashOps().increment((Object)key, (Object)field, delta);
    }

    public static Set<String> hKeys(String key) {
        return RedisHelper.hashOps().keys((Object)key);
    }

    public static long hLen(String key) {
        return RedisHelper.hashOps().size((Object)key);
    }

    public static List<String> hMGet(String key, Collection<String> fields) {
        return RedisHelper.hashOps().multiGet((Object)key, fields);
    }

    public static List<String> hMGet(String key, String ... fields) {
        return RedisHelper.hashOps().multiGet((Object)key, Arrays.asList(fields));
    }

    public static void hSet(String key, String field, String value) {
        RedisHelper.hashOps().put((Object)key, (Object)field, (Object)value);
    }

    @Deprecated
    public static void hashSet(String key, String field, String value) {
        RedisHelper.hashOps().put((Object)key, (Object)field, (Object)value);
    }

    public static void hSetNx(String key, String field, String value) {
        RedisHelper.hashOps().putIfAbsent((Object)key, (Object)field, (Object)value);
    }

    public static List<String> hVals(String key) {
        return RedisHelper.hashOps().values((Object)key);
    }

    @Deprecated
    public static String hashGet(String key, String field) {
        Object o = RedisHelper.hashOps().get((Object)key, (Object)field);
        return o == null ? null : o.toString();
    }

    @Deprecated
    public static Long hashDelete(String key, String ... fields) {
        return RedisHelper.hashOps().delete((Object)key, (Object[])fields);
    }

    public static String lIndex(String key, long index) {
        return (String)RedisHelper.listOps().index((Object)key, index);
    }

    @Deprecated
    public static String listIndex(String key, long index) {
        return (String)RedisHelper.listOps().index((Object)key, index);
    }

    public static long lLen(String key) {
        return RedisHelper.listOps().size((Object)key);
    }

    @Deprecated
    public static long listSize(String key) {
        Long size = RedisHelper.listOps().size((Object)key);
        return size == null ? 0L : size;
    }

    public static String lPop(String key) {
        return (String)RedisHelper.listOps().leftPop((Object)key);
    }

    public static List<String> lPop(String key, long count) {
        return RedisHelper.listOps().leftPop((Object)key, count);
    }

    @Deprecated
    public static String listLeftPop(String key) {
        return (String)RedisHelper.listOps().leftPop((Object)key);
    }

    public static Long lPos(String key, String element) {
        return RedisHelper.listOps().indexOf((Object)key, (Object)element);
    }

    @Deprecated
    public static Long listIndexOf(String key, String val) {
        return RedisHelper.listOps().indexOf((Object)key, (Object)val);
    }

    public static long lPush(String key, String ... elements) {
        return RedisHelper.listOps().leftPushAll((Object)key, (Object[])elements);
    }

    public static long lPush(String key, List<String> elements) {
        return RedisHelper.listOps().leftPushAll((Object)key, elements);
    }

    @Deprecated
    public static Long listLeftPush(String key, String val) {
        return RedisHelper.listOps().leftPush((Object)key, (Object)val);
    }

    public static List<String> lRange(String key, long start, long end) {
        return RedisHelper.listOps().range((Object)key, start, end);
    }

    @Deprecated
    public static List<String> listGet(String key) {
        return RedisHelper.listOps().range((Object)key, 0L, RedisHelper.listSize(key) - 1L);
    }

    public static long lRem(String key, long count, String value) {
        return RedisHelper.listOps().remove((Object)key, count, (Object)value);
    }

    @Deprecated
    public static Long listRemove(String key, String val) {
        return RedisHelper.listRemove(key, 1L, val);
    }

    @Deprecated
    public static Long listRemove(String key, long count, String val) {
        return RedisHelper.listOps().remove((Object)key, count, (Object)val);
    }

    @Deprecated
    private static long listSet(String key, List<String> list) {
        long l = 0L;
        for (String str : list) {
            l += RedisHelper.listLeftPush(key, str).longValue();
        }
        return l;
    }

    @Deprecated
    public static long listSet(String key, List<String> list, long time) {
        long l = RedisHelper.listSet(key, list);
        RedisHelper.expire(key, time);
        return l;
    }

    public static void lSet(String key, long index, String value) {
        RedisHelper.listOps().set((Object)key, index, (Object)value);
    }

    public static void lTrim(String key, long start, long end) {
        RedisHelper.listOps().trim((Object)key, start, end);
    }

    public static String rPop(String key) {
        return (String)RedisHelper.listOps().rightPop((Object)key);
    }

    public static List<String> rPop(String key, long count) {
        return RedisHelper.listOps().rightPop((Object)key, count);
    }

    public static long rPush(String key, String ... values) {
        return RedisHelper.listOps().rightPushAll((Object)key, (Object[])values);
    }

    public static long rPush(String key, List<String> values) {
        return RedisHelper.listOps().rightPushAll((Object)key, values);
    }

    @Deprecated
    public static Long listRightPush(String key, String val) {
        return RedisHelper.listOps().rightPush((Object)key, (Object)val);
    }

    @Deprecated
    public static String listRightPop(String key) {
        return (String)RedisHelper.listOps().rightPop((Object)key);
    }

    public static long sAdd(String key, String ... members) {
        return RedisHelper.setOps().add((Object)key, (Object[])members);
    }

    public static long sAdd(String key, List<String> members) {
        return RedisHelper.setOps().add((Object)key, (Object[])members.toArray(new String[0]));
    }

    @Deprecated
    public static Long setAdd(String key, String ... values) {
        return RedisHelper.setOps().add((Object)key, (Object[])values);
    }

    public static long sCard(String key) {
        return RedisHelper.setOps().size((Object)key);
    }

    @Deprecated
    public static Long setSize(String key) {
        return RedisHelper.setOps().size((Object)key);
    }

    public static boolean sIsMember(String key, String value) {
        return RedisHelper.setOps().isMember((Object)key, (Object)value);
    }

    public static Set<String> sMembers(String key) {
        return RedisHelper.setOps().members((Object)key);
    }

    public static Map<Object, Boolean> sMIsMember(String key, String ... values) {
        return RedisHelper.setOps().isMember((Object)key, (Object[])values);
    }

    public static String sPop(String key) {
        return (String)RedisHelper.setOps().pop((Object)key);
    }

    @Deprecated
    public static String setPop(String key) {
        return (String)RedisHelper.setOps().pop((Object)key);
    }

    public static String sRandMember(String key) {
        return (String)RedisHelper.setOps().randomMember((Object)key);
    }

    public static Set<String> sRandMember(String key, long count) {
        return RedisHelper.setOps().distinctRandomMembers((Object)key, count);
    }

    public static long sRem(String key, String ... members) {
        return RedisHelper.setOps().remove((Object)key, (Object[])members);
    }

    @Deprecated
    public static Long setRemove(String key, String ... values) {
        return RedisHelper.setOps().remove((Object)key, (Object[])values);
    }

    public static Cursor<String> sScan(String key, ScanOptions scanOptions) {
        return RedisHelper.setOps().scan((Object)key, scanOptions);
    }

    public static boolean zAdd(String key, double score, String member) {
        return RedisHelper.zSetOps().add((Object)key, (Object)member, score);
    }

    public static long zAdd(String key, Map<String, Double> scoreMembers) {
        Set tuples = scoreMembers.entrySet().stream().map(x -> ZSetOperations.TypedTuple.of(x.getKey(), (Double)((Double)x.getValue()))).collect(Collectors.toSet());
        return RedisHelper.zSetOps().add((Object)key, tuples);
    }

    @Deprecated
    public static Boolean zSetAdd(String key, String value, double score) {
        return RedisHelper.zSetOps().add((Object)key, (Object)value, score);
    }

    public static long zCard(String key) {
        return RedisHelper.zSetOps().size((Object)key);
    }

    @Deprecated
    public static Long zSetSize(String key) {
        return RedisHelper.zSetOps().size((Object)key);
    }

    public static double zIncrBy(String key, double increment, String member) {
        return RedisHelper.zSetOps().incrementScore((Object)key, (Object)member, increment);
    }

    public static ZSetOperations.TypedTuple<String> zPopMax(String key) {
        return RedisHelper.zSetOps().popMax((Object)key);
    }

    public static Set<ZSetOperations.TypedTuple<String>> zPopMax(String key, long count) {
        return RedisHelper.zSetOps().popMax((Object)key, count);
    }

    public static ZSetOperations.TypedTuple<String> zPopMin(String key) {
        return RedisHelper.zSetOps().popMin((Object)key);
    }

    public static Set<ZSetOperations.TypedTuple<String>> zPopMin(String key, long count) {
        return RedisHelper.zSetOps().popMin((Object)key, count);
    }

    public static String zRandMember(String key) {
        return (String)RedisHelper.zSetOps().randomMember((Object)key);
    }

    @Deprecated
    public static String zSetRandom(String key) {
        return (String)RedisHelper.zSetOps().randomMember((Object)key);
    }

    public static Set<String> zRange(String key, long start, long end) {
        return RedisHelper.zSetOps().range((Object)key, start, end);
    }

    public static Set<String> zRangeByScore(String key, double min, double max) {
        return RedisHelper.zSetOps().rangeByScore((Object)key, min, max);
    }

    public static Set<String> zRangeByScore(String key, double min, double max, long offset, long count) {
        return RedisHelper.zSetOps().rangeByScore((Object)key, min, max, offset, count);
    }

    public static Set<ZSetOperations.TypedTuple<String>> zRangeByScoreWithScores(String key, double min, double max) {
        return RedisHelper.zSetOps().rangeByScoreWithScores((Object)key, min, max);
    }

    public static Long zRank(String key, String member) {
        return RedisHelper.zSetOps().rank((Object)key, (Object)member);
    }

    public static long zRem(String key, String ... members) {
        return RedisHelper.zSetOps().remove((Object)key, (Object[])members);
    }

    @Deprecated
    public static Long zSetRemove(String key, String ... values) {
        return RedisHelper.zSetOps().remove((Object)key, (Object[])values);
    }

    @Deprecated
    public static Long zSetRank(String key, String value) {
        return RedisHelper.zSetOps().rank((Object)key, (Object)value);
    }

    public static Set<String> zRevRange(String key, long start, long end) {
        return RedisHelper.zSetOps().reverseRange((Object)key, start, end);
    }

    public static Set<String> zRevRangeByScore(String key, double min, double max) {
        return RedisHelper.zSetOps().reverseRangeByScore((Object)key, min, max);
    }

    public static Double zScore(String key, String member) {
        return RedisHelper.zSetOps().score((Object)key, (Object)member);
    }

    @Deprecated
    public static Set<String> zSetRange(String key, int start, int end) {
        return RedisHelper.zSetOps().range((Object)key, (long)start, (long)end);
    }

    @Deprecated
    public static Set<String> zSetReverseRange(String key, int start, int end) {
        return RedisHelper.zSetOps().reverseRange((Object)key, (long)start, (long)end);
    }

    @Deprecated
    public static Set<String> zSetRangeByScore(String key, double min, double max) {
        return RedisHelper.zSetOps().rangeByScore((Object)key, min, max);
    }

    @Deprecated
    public static Set<String> zSetReverseRangeByScore(String key, double min, double max) {
        return RedisHelper.zSetOps().reverseRangeByScore((Object)key, min, max);
    }

    public static <T> T execute(RedisCallback<T> action) {
        return (T)redisTemplate.execute(action);
    }

    @Nullable
    public static <T> T execute(RedisCallback<T> action, boolean exposeConnection) {
        return RedisHelper.execute(action, exposeConnection, false);
    }

    @Nullable
    public static <T> T execute(RedisCallback<T> action, boolean exposeConnection, boolean pipeline) {
        return (T)redisTemplate.execute(action, exposeConnection, pipeline);
    }

    public static <T> T execute(SessionCallback<T> session) {
        return (T)redisTemplate.execute(session);
    }

    public static <T> T execute(RedisScript<T> script, List<String> keys, Object ... args) {
        return (T)redisTemplate.execute(script, keys, args);
    }

    public static <T> T execute(RedisScript<T> script, RedisSerializer<?> argsSerializer, RedisSerializer<T> resultSerializer, List<String> keys, Object ... args) {
        return (T)redisTemplate.execute(script, argsSerializer, resultSerializer, keys, args);
    }

    @Deprecated
    public static Object evalLua(String lua, List<String> key, Object ... argv) {
        Object[] arg = (String[])Arrays.stream(argv).map(String::valueOf).toArray(String[]::new);
        try {
            DefaultRedisScript redisScript = new DefaultRedisScript(lua, String.class);
            return redisTemplate.execute((RedisScript)redisScript, RedisSerializer.string(), RedisSerializer.string(), key, arg);
        }
        catch (Exception e) {
            log.error("redis evalLua execute fail:lua[{}]", (Object)lua, (Object)e);
            return "false";
        }
    }

    public static List<Object> executePipelined(SessionCallback<?> session) {
        return redisTemplate.executePipelined(session);
    }

    public static List<Object> executePipelined(SessionCallback<?> session, @Nullable RedisSerializer<?> resultSerializer) {
        return redisTemplate.executePipelined(session, resultSerializer);
    }

    public static List<Object> executePipelined(RedisCallback<?> action) {
        return redisTemplate.executePipelined(action);
    }

    public static List<Object> executePipelined(RedisCallback<?> action, @Nullable RedisSerializer<?> resultSerializer) {
        return redisTemplate.executePipelined(action, resultSerializer);
    }

    public static void publish(String channel, String message) {
        redisTemplate.convertAndSend(channel, (Object)message);
    }

    public static void publish(String channel, byte[] message) {
        redisTemplate.convertAndSend(channel, (Object)message);
    }

    public static long xAck(String key, String group, String ... ids) {
        return RedisHelper.streamOps().acknowledge((Object)key, group, ids);
    }

    public static long xAck(String key, String group, RecordId ... ids) {
        return RedisHelper.streamOps().acknowledge((Object)key, group, ids);
    }

    public static RecordId xAdd(String key, Map<String, String> content) {
        return RedisHelper.streamOps().add(StreamRecords.newRecord().in((Object)key).ofMap(content));
    }

    public static RecordId xAdd(String key, Map<String, String> content, RedisStreamCommands.XAddOptions xAddOptions) {
        return RedisHelper.xAdd((MapRecord<String, String, String>)Record.of(content).withStreamKey((Object)key), xAddOptions);
    }

    public static RecordId xAdd(MapRecord<String, String, String> mapRecord, RedisStreamCommands.XAddOptions xAddOptions) {
        RedisSerializer<String> keySerializer = RedisHelper.getKeySerializer();
        RedisSerializer<String> valueSerializer = RedisHelper.getValueSerializer();
        byte[] rawKey = keySerializer.serialize(mapRecord.getStream());
        Map content = (Map)mapRecord.getValue();
        LinkedHashMap<byte[], byte[]> rawContent = new LinkedHashMap<byte[], byte[]>(content.size());
        for (Map.Entry entry : content.entrySet()) {
            rawContent.put(keySerializer.serialize(entry.getKey()), valueSerializer.serialize(entry.getValue()));
        }
        return (RecordId)redisTemplate.execute(conn -> conn.streamCommands().xAdd(Record.of((Map)rawContent).withStreamKey((Object)rawKey), xAddOptions));
    }

    public static long xDel(String key, String ... ids) {
        return RedisHelper.streamOps().delete((Object)key, ids);
    }

    public static long xDel(String key, RecordId ... ids) {
        return RedisHelper.streamOps().delete((Object)key, ids);
    }

    public static String xGroupCreate(String key, String groupName, ReadOffset readOffset, boolean makeStream) {
        RedisSerializer<String> keySerializer = RedisHelper.getKeySerializer();
        byte[] rawKey = keySerializer.serialize((Object)key);
        return (String)redisTemplate.execute(conn -> conn.streamCommands().xGroupCreate(rawKey, groupName, readOffset, makeStream));
    }

    public static String xGroupCreate(String key, String groupName) {
        return RedisHelper.xGroupCreate(key, groupName, ReadOffset.latest(), true);
    }

    public static long xLen(String key) {
        return RedisHelper.streamOps().size((Object)key);
    }

    public static List<MapRecord<String, String, String>> xRange(String key, Range<String> range) {
        return RedisHelper.streamOps().range((Object)key, range);
    }

    public static List<MapRecord<String, String, String>> xRange(String key, Range<String> range, RedisZSetCommands.Limit limit) {
        return RedisHelper.streamOps().range((Object)key, range, limit);
    }

    public static List<MapRecord<String, String, String>> xRead(StreamOffset<String> ... streams) {
        return RedisHelper.streamOps().read(streams);
    }

    public static List<MapRecord<String, String, String>> xRead(StreamReadOptions streamReadOptions, StreamOffset<String> ... streams) {
        return RedisHelper.streamOps().read(streamReadOptions, streams);
    }

    public static List<MapRecord<String, String, String>> xReadGroup(Consumer consumer, StreamOffset<String> ... streams) {
        return RedisHelper.streamOps().read(consumer, streams);
    }

    public static List<MapRecord<String, String, String>> xReadGroup(Consumer consumer, StreamReadOptions streamReadOptions, StreamOffset<String> ... streams) {
        return RedisHelper.streamOps().read(consumer, streamReadOptions, streams);
    }

    public static List<MapRecord<String, String, String>> xReadGroup(String group, String consumer, StreamOffset<String> ... streams) {
        return RedisHelper.streamOps().read(Consumer.from((String)group, (String)consumer), streams);
    }

    public static List<MapRecord<String, String, String>> xReadGroup(String group, String consumer, StreamReadOptions streamReadOptions, StreamOffset<String> ... streams) {
        return RedisHelper.streamOps().read(Consumer.from((String)group, (String)consumer), streamReadOptions, streams);
    }
}

