/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.redis.core;

import com.hccake.ballcat.common.redis.RedisHelper;
import com.hccake.ballcat.common.redis.config.CachePropertiesHolder;
import com.hccake.ballcat.common.redis.core.KeyGenerator;
import com.hccake.ballcat.common.redis.core.annotation.CacheDel;
import com.hccake.ballcat.common.redis.core.annotation.CacheDels;
import com.hccake.ballcat.common.redis.core.annotation.CachePut;
import com.hccake.ballcat.common.redis.core.annotation.Cached;
import com.hccake.ballcat.common.redis.lock.DistributedLock;
import com.hccake.ballcat.common.redis.operation.CacheDelOps;
import com.hccake.ballcat.common.redis.operation.CacheDelsOps;
import com.hccake.ballcat.common.redis.operation.CachePutOps;
import com.hccake.ballcat.common.redis.operation.CachedOps;
import com.hccake.ballcat.common.redis.operation.function.VoidMethod;
import com.hccake.ballcat.common.redis.serialize.CacheSerializer;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ValueOperations;

@Aspect
@Order(value=0x7FFFFFFE)
public class CacheStringAspect {
    Logger log = LoggerFactory.getLogger(CacheStringAspect.class);
    private final CacheSerializer cacheSerializer;
    private final StringRedisTemplate redisTemplate;

    public CacheStringAspect(StringRedisTemplate redisTemplate, CacheSerializer cacheSerializer) {
        this.redisTemplate = redisTemplate;
        this.cacheSerializer = cacheSerializer;
    }

    @Pointcut(value="execution(@(@com.hccake.ballcat.common.redis.core.annotation.MetaCacheAnnotation *) * *(..))")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        if (this.log.isTraceEnabled()) {
            this.log.trace("=======The string cache aop is executed! method : {}", (Object)method.getName());
        }
        Object target = point.getTarget();
        Object[] arguments = point.getArgs();
        KeyGenerator keyGenerator = new KeyGenerator(target, method, arguments);
        ValueOperations valueOperations = this.redisTemplate.opsForValue();
        Cached cachedAnnotation = (Cached)AnnotationUtils.getAnnotation((Method)method, Cached.class);
        if (cachedAnnotation != null) {
            String key = keyGenerator.getKey(cachedAnnotation.key(), cachedAnnotation.keyJoint());
            String lockKey = key + CachePropertiesHolder.lockKeySuffix();
            Supplier<String> cacheQuery = () -> (String)valueOperations.get((Object)key);
            Consumer<Object> cachePut = this.prodCachePutFunction((ValueOperations<String, String>)valueOperations, key, cachedAnnotation.ttl(), cachedAnnotation.timeUnit());
            return this.cached(new CachedOps(point, lockKey, cacheQuery, cachePut, method.getGenericReturnType()));
        }
        CachePut cachePutAnnotation = (CachePut)AnnotationUtils.getAnnotation((Method)method, CachePut.class);
        if (cachePutAnnotation != null) {
            String key = keyGenerator.getKey(cachePutAnnotation.key(), cachePutAnnotation.keyJoint());
            Consumer<Object> cachePut = this.prodCachePutFunction((ValueOperations<String, String>)valueOperations, key, cachePutAnnotation.ttl(), cachePutAnnotation.timeUnit());
            return this.cachePut(new CachePutOps(point, cachePut));
        }
        CacheDel cacheDelAnnotation = (CacheDel)AnnotationUtils.getAnnotation((Method)method, CacheDel.class);
        if (cacheDelAnnotation != null) {
            return this.cacheDel(new CacheDelOps(point, this.buildCacheDelExecution(cacheDelAnnotation, keyGenerator)));
        }
        CacheDels cacheDelsAnnotation = (CacheDels)AnnotationUtils.getAnnotation((Method)method, CacheDels.class);
        if (cacheDelsAnnotation != null) {
            int annotationCount = cacheDelsAnnotation.value().length;
            VoidMethod[] cacheDels = new VoidMethod[annotationCount];
            for (int i = 0; i < annotationCount; ++i) {
                cacheDels[i] = this.buildCacheDelExecution(cacheDelsAnnotation.value()[i], keyGenerator);
            }
            return this.cacheDels(new CacheDelsOps(point, cacheDels));
        }
        return point.proceed();
    }

    private Consumer<Object> prodCachePutFunction(ValueOperations<String, String> valueOperations, String key, long ttl, TimeUnit unit) {
        Consumer<Object> cachePut = ttl < 0L ? value -> valueOperations.set((Object)key, (Object)((String)value)) : (ttl == 0L ? value -> valueOperations.set((Object)key, (Object)((String)value), CachePropertiesHolder.expireTime(), unit) : value -> valueOperations.set((Object)key, (Object)((String)value), ttl, unit));
        return cachePut;
    }

    public Object cached(CachedOps ops) throws Throwable {
        Supplier<String> cacheQuery = ops.cacheQuery();
        Type dataClazz = ops.returnType();
        String cacheData = cacheQuery.get();
        if (ops.nullValue(cacheData)) {
            return null;
        }
        if (cacheData != null) {
            return this.cacheSerializer.deserialize(cacheData, dataClazz);
        }
        cacheData = DistributedLock.instance().action(ops.lockKey(), () -> {
            String cacheValue = (String)cacheQuery.get();
            if (cacheValue == null) {
                Object dbValue = ops.joinPoint().proceed();
                cacheValue = dbValue == null ? CachePropertiesHolder.nullValue() : this.cacheSerializer.serialize(dbValue);
                ops.cachePut().accept(cacheValue);
            }
            return cacheValue;
        }).onLockFail(cacheQuery).lock();
        if (cacheData == null || ops.nullValue(cacheData)) {
            return null;
        }
        return this.cacheSerializer.deserialize(cacheData, dataClazz);
    }

    private Object cachePut(CachePutOps ops) throws Throwable {
        Object data = ops.joinPoint().proceed();
        String cacheData = data == null ? CachePropertiesHolder.nullValue() : this.cacheSerializer.serialize(data);
        ops.cachePut().accept(cacheData);
        return data;
    }

    private Object cacheDel(CacheDelOps ops) throws Throwable {
        Object data = ops.joinPoint().proceed();
        ops.cacheDel().run();
        return data;
    }

    private Object cacheDels(CacheDelsOps ops) throws Throwable {
        Object data = ops.joinPoint().proceed();
        for (VoidMethod voidMethod : ops.cacheDel()) {
            voidMethod.run();
        }
        return data;
    }

    private VoidMethod buildCacheDelExecution(CacheDel cacheDelAnnotation, KeyGenerator keyGenerator) {
        VoidMethod cacheDel;
        if (cacheDelAnnotation.allEntries()) {
            cacheDel = () -> {
                Cursor<String> scan = RedisHelper.scan(cacheDelAnnotation.key().concat("*"));
                while (scan.hasNext()) {
                    this.redisTemplate.delete(scan.next());
                }
                if (!scan.isClosed()) {
                    scan.close();
                }
            };
        } else if (cacheDelAnnotation.multiDel()) {
            List<String> keys = keyGenerator.getKeys(cacheDelAnnotation.key(), cacheDelAnnotation.keyJoint());
            cacheDel = () -> this.redisTemplate.delete(keys);
        } else {
            String key = keyGenerator.getKey(cacheDelAnnotation.key(), cacheDelAnnotation.keyJoint());
            cacheDel = () -> this.redisTemplate.delete((Object)key);
        }
        return cacheDel;
    }
}

