/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.redis.keyevent.listener;

import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.core.RedisKeyExpiredEvent;
import org.springframework.data.redis.listener.KeyspaceEventMessageListener;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public abstract class AbstractKeySpaceEventMessageListener
extends KeyspaceEventMessageListener
implements ApplicationEventPublisherAware {
    @Nullable
    protected ApplicationEventPublisher publisher;

    protected AbstractKeySpaceEventMessageListener(@NonNull RedisMessageListenerContainer listenerContainer) {
        super(listenerContainer);
    }

    protected void doRegister(@NonNull RedisMessageListenerContainer listenerContainer) {
        listenerContainer.addMessageListener((MessageListener)this, this.getKeyEventTopic());
    }

    protected void doHandleMessage(@NonNull Message message) {
        this.publishEvent(new RedisKeyExpiredEvent(message.getBody()));
    }

    protected void publishEvent(RedisKeyExpiredEvent<?> event) {
        if (this.publisher != null) {
            this.publisher.publishEvent(event);
        }
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }

    public abstract Topic getKeyEventTopic();
}

