/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.redis.keyevent.listener;

import com.hccake.ballcat.common.redis.keyevent.listener.AbstractExpiredKeyEventMessageListener;
import com.hccake.ballcat.common.redis.keyevent.template.KeyExpiredEventMessageTemplate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.util.CollectionUtils;

public class DefaultExpiredKeyEventMessageListener
extends AbstractExpiredKeyEventMessageListener {
    private static final Logger log = LoggerFactory.getLogger(DefaultExpiredKeyEventMessageListener.class);
    protected List<KeyExpiredEventMessageTemplate> keyExpiredEventMessageTemplates;

    public DefaultExpiredKeyEventMessageListener(RedisMessageListenerContainer listenerContainer) {
        super(listenerContainer);
    }

    public DefaultExpiredKeyEventMessageListener(RedisMessageListenerContainer listenerContainer, ObjectProvider<List<KeyExpiredEventMessageTemplate>> objectProvider) {
        super(listenerContainer);
        objectProvider.ifAvailable(templates -> {
            this.keyExpiredEventMessageTemplates = new ArrayList<KeyExpiredEventMessageTemplate>((Collection<KeyExpiredEventMessageTemplate>)templates);
        });
    }

    public void onMessage(Message message, byte[] pattern) {
        if (CollectionUtils.isEmpty(this.keyExpiredEventMessageTemplates)) {
            return;
        }
        super.onMessage(message, pattern);
        String expiredKey = message.toString();
        for (KeyExpiredEventMessageTemplate keyExpiredEventMessageTemplate : this.keyExpiredEventMessageTemplates) {
            if (!keyExpiredEventMessageTemplate.support(expiredKey)) continue;
            if (log.isTraceEnabled()) {
                log.trace("use template[{}]handle key expired event,the expired key is [{}]", (Object)keyExpiredEventMessageTemplate.getClass().getName(), (Object)expiredKey);
            }
            keyExpiredEventMessageTemplate.handleMessage(expiredKey);
        }
    }
}

