/*
 * Decompiled with CFR 0.152.
 */
package com.hccake.ballcat.common.redis.listener;

import com.hccake.ballcat.common.redis.listener.MessageEventListener;
import com.hccake.ballcat.common.util.JsonUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;

public abstract class AbstractMessageEventListener<T>
implements MessageEventListener {
    @Autowired
    protected StringRedisTemplate stringRedisTemplate;
    protected final Class<T> clz;

    protected AbstractMessageEventListener() {
        Type superClass = this.getClass().getGenericSuperclass();
        ParameterizedType type = (ParameterizedType)superClass;
        this.clz = (Class)type.getActualTypeArguments()[0];
    }

    public void onMessage(Message message, byte[] pattern) {
        byte[] channelBytes = message.getChannel();
        RedisSerializer stringSerializer = this.stringRedisTemplate.getStringSerializer();
        String channelTopic = (String)stringSerializer.deserialize(channelBytes);
        String topic = this.topic().getTopic();
        if (topic.equals(channelTopic)) {
            byte[] bodyBytes = message.getBody();
            String body = (String)stringSerializer.deserialize(bodyBytes);
            Object decodeMessage = JsonUtils.toObj((String)body, this.clz);
            this.handleMessage(decodeMessage);
        }
    }

    protected abstract void handleMessage(T var1);
}

